/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.util;

import java.util.ArrayList;
import java.util.Properties;

public class StringUtil {
    public static String expandVariables(String str, Properties props) {
        if (str == null) {
            return str;
        }
        String value = null;
        int len = str.length();
        StringBuffer sbuf = null;
        int vend = 0;
        int vstart = 0;
        int current = 0;
        while (current < len) {
            String vname;
            vstart = str.indexOf(36, current);
            if (vstart == -1) {
                if (sbuf == null) break;
                sbuf.append(str.substring(current, len));
                break;
            }
            if (str.charAt(vstart + 1) == '{' && (vend = str.indexOf(125, vstart + 1)) == -1) {
                if (sbuf == null) break;
                sbuf.append(str.substring(current, len));
                break;
            }
            if (sbuf == null) {
                sbuf = new StringBuffer(2 * len);
            }
            if (vend > vstart) {
                vname = str.substring(vstart + 2, vend);
            } else {
                vname = null;
                vend = vstart;
            }
            if (vname == null) {
                value = null;
            } else if (vname.equals("/")) {
                value = System.getProperty("file.separator");
            } else if (vname.equals("NL")) {
                value = System.getProperty("line.separator");
            } else if (props != null) {
                value = props.getProperty(vname);
            }
            sbuf.append(str.substring(current, vstart));
            if (value == null) {
                sbuf.append(str.substring(vstart, vend + 1));
            } else {
                sbuf.append(value);
            }
            current = vend + 1;
        }
        if (sbuf != null) {
            return sbuf.toString();
        }
        return str;
    }

    public static String[] split(String str, char separatorChar) {
        return StringUtil.splitWorker(str, separatorChar, false);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String join(Object[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int bufSize = endIndex - startIndex;
        if (bufSize <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + 1);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtil.join(array, separator, 0, array.length);
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

