/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.ConnectionFactory;
import com.tongtech.tmqi.Queue;
import java.util.logging.Level;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;

public class MultiThreadQueue
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(MultiThreadQueue.class);
    static int connNum = 1;
    static int type = 0;
    static Connection[] myConn = new Connection[connNum];
    static Session[] mySess = new Session[connNum];
    static MessageConsumer myMsgConsumer = null;
    static MessageProducer[] myMsgProducer = new MessageProducer[connNum];
    static BytesMessage[] myBytesMsg = new BytesMessage[connNum];
    int n = 0;

    public MultiThreadQueue(int a) {
        this.n = a;
    }

    public static void main(String[] args) {
        System.out.println("start...java test.MultiThreadQueue \u8fde\u63a5\u6570 type(0-read write 1-only read 2-only write");
        if (args.length == 1) {
            connNum = Integer.parseInt(args[0]);
        } else if (args.length == 2) {
            connNum = Integer.parseInt(args[0]);
            type = Integer.parseInt(args[1]);
        }
        try {
            Thread[] thread = new Thread[connNum];
            ConnectionFactory myConnFactory = new ConnectionFactory();
            Queue myQueue = new Queue("lq1");
            String text = "Hello World";
            for (int m = 0; m < connNum; ++m) {
                MultiThreadQueue.myConn[m] = myConnFactory.createConnection();
                MultiThreadQueue.mySess[m] = myConn[m].createSession(false, 1);
                MultiThreadQueue.myMsgProducer[m] = mySess[m].createProducer((Destination)myQueue);
                myConn[m].start();
                MultiThreadQueue.myBytesMsg[m] = mySess[m].createBytesMessage();
                myBytesMsg[m].writeBytes(text.getBytes());
                MultiThreadQueue multi = new MultiThreadQueue(m);
                thread[m] = new Thread(multi);
            }
            if (type == 0 || type == 1) {
                for (int bb = 0; bb < connNum; ++bb) {
                    Thread readThread = new Thread(new ReadThread());
                    readThread.start();
                }
            }
            if (type == 0 || type == 2) {
                for (int aa = 0; aa < connNum; ++aa) {
                    thread[aa].start();
                }
            }
        }
        catch (Exception jmse) {
            System.out.println("Exception occurred : " + jmse.toString());
            jmse.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            try {
                for (int i = 0; i < 10000; ++i) {
                    myMsgProducer[this.n].send((Message)myBytesMsg[this.n]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mySess[this.n].close();
            myConn[this.n].close();
        }
        catch (JMSException ex) {
            java.util.logging.Logger.getLogger(MultiThreadQueue.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static class ReadThread
    implements Runnable {
        MessageConsumer consumer = null;
        Session session = null;
        Connection conntion = null;

        public ReadThread() {
            try {
                Queue queue = new Queue("lq1");
                this.conntion = new ConnectionFactory().createConnection();
                this.session = this.conntion.createSession(false, 1);
                this.consumer = this.session.createConsumer((Destination)queue);
                this.conntion.start();
            }
            catch (JMSException ex) {
                java.util.logging.Logger.getLogger(MultiThreadQueue.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void run() {
            try {
                long a = System.currentTimeMillis();
                try {
                    for (int i = 0; i < 10000; ++i) {
                        this.consumer.receive();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("read loop time end:" + (System.currentTimeMillis() - a));
                this.session.close();
                this.conntion.close();
            }
            catch (JMSException ex) {
                java.util.logging.Logger.getLogger(MultiThreadQueue.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

