/*
 * Decompiled with CFR 0.152.
 */
package tongtech.jms.jndi;

import com.tongtech.tlq.basement.ServerKernel;
import com.tongtech.tlq.basement.TlqException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class INIParser {
    private HashMap mSections;

    public INIParser(String aFilename, Charset aCharset) throws FileNotFoundException, IOException {
        this.initFromFile(new File(aFilename), aCharset);
    }

    public INIParser(String aFilename) throws FileNotFoundException, IOException {
        this.initFromFile(new File(aFilename), Charset.forName("UTF-8"));
    }

    public INIParser(File aFile, Charset aCharset) throws FileNotFoundException, IOException {
        this.initFromFile(aFile, aCharset);
    }

    public INIParser(File aFile) throws FileNotFoundException, IOException {
        this.initFromFile(aFile, Charset.forName("UTF-8"));
    }

    private void initFromFile(File aFile, Charset aCharset) throws FileNotFoundException, IOException {
        String line;
        byte[] bData = null;
        try {
            new ServerKernel();
            if (ServerKernel.IsLicenseCrypt() == 1) {
                bData = ServerKernel.ReadJndiConf(aFile.getAbsolutePath());
            }
        }
        catch (TlqException e) {
            throw new IOException(e.getMessage());
        }
        FileInputStream fileStream = null;
        InputStreamReader inStream = null;
        ByteArrayInputStream bInputStream = null;
        if (bData != null) {
            bInputStream = new ByteArrayInputStream(bData);
            inStream = new InputStreamReader((InputStream)bInputStream, aCharset);
        } else {
            fileStream = new FileInputStream(aFile);
            inStream = new InputStreamReader((InputStream)fileStream, aCharset);
        }
        BufferedReader reader = new BufferedReader(inStream);
        this.mSections = new HashMap();
        String currSection = null;
        boolean alreadyExist = false;
        boolean lastLineIsSection = false;
        List<Properties> propsList = null;
        while ((line = reader.readLine()) != null) {
            StringTokenizer tok;
            String trimmedLine = line.trim();
            trimmedLine = trimmedLine.replaceAll(" ", "");
            if ((trimmedLine = trimmedLine.replaceAll("\t", "")).length() == 0 || trimmedLine.startsWith("#") || trimmedLine.startsWith(";")) continue;
            int pos = trimmedLine.indexOf(35);
            if (pos > 0) {
                trimmedLine = trimmedLine.substring(0, pos);
            }
            if (trimmedLine.startsWith("[")) {
                if (!trimmedLine.endsWith("]") || trimmedLine.indexOf("]") != trimmedLine.length() - 1) {
                    currSection = null;
                    continue;
                }
                currSection = trimmedLine.substring(1, trimmedLine.length() - 1);
                propsList = (List)this.mSections.get(currSection);
                alreadyExist = propsList != null;
                lastLineIsSection = true;
                continue;
            }
            if (currSection == null || (tok = new StringTokenizer(trimmedLine, "=")).countTokens() != 2) continue;
            Properties props = null;
            if (lastLineIsSection) {
                props = new Properties();
                if (!alreadyExist) {
                    propsList = new ArrayList<Properties>();
                    this.mSections.put(currSection, propsList);
                }
                propsList.add(props);
            } else {
                propsList = (ArrayList<Properties>)this.mSections.get(currSection);
                props = (Properties)propsList.get(propsList.size() - 1);
            }
            props.setProperty(tok.nextToken(), tok.nextToken());
            lastLineIsSection = false;
        }
        reader.close();
    }

    public Iterator getSections() {
        return this.mSections.keySet().iterator();
    }

    public List getSectionAsPropertiesList(String aSection) {
        return (List)this.mSections.get(aSection);
    }
}

