/*
 * Decompiled with CFR 0.152.
 */
package tongtech.jms.jndi;

import com.tongtech.jms.transport.httptunnel.HttpTunnelSocket;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.protocol.wireformat.WireFormatFactory;
import com.tongtech.remote.protocol.OpenWireFormat;
import com.tongtech.remote.protocol.OpenWireFormatFactory;
import com.tongtech.remote.protocol.command.Command;
import com.tongtech.remote.protocol.command.DataStructure;
import com.tongtech.remote.protocol.command.ExceptionResponse;
import com.tongtech.remote.protocol.command.JndiRequest;
import com.tongtech.remote.protocol.command.StringRRResponse;
import com.tongtech.tmqi.Destination;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import tongtech.jms.jndi.JmsContextFactory;

public class SocketNamingContext
implements Context {
    static Logger logger = LoggerFactory.getLogger(SocketNamingContext.class);
    private static final byte[] MAGIC = new byte[]{84, 111, 110, 103, 95, 74, 77, 83};
    private static final int DEFAULT_PORTMAPPER_PORT = 10025;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static WireFormatFactory wireformatFactory = new OpenWireFormatFactory();
    private int port;
    private String addrHost;
    private Hashtable env;
    private Socket socket;
    private HttpTunnelSocket httpSocket;
    private OpenWireFormat readWireformat;
    private OpenWireFormat writeWireformat;
    private DataOutputStream os;
    private DataInputStream is;
    private boolean createNewConnection = true;
    private Integer timeout;
    private boolean lookupMulti = false;
    private String addr;

    public SocketNamingContext(Hashtable env, String url) throws NamingException {
        this.env = env;
        this.parseAndValidate(url);
        this.init();
    }

    private void init() throws NamingException {
        this.writeWireformat = (OpenWireFormat)wireformatFactory.createWireFormat();
        this.readWireformat = (OpenWireFormat)wireformatFactory.createWireFormat();
        this.writeWireformat.setTightEncodingEnabled(true);
        this.readWireformat.setTightEncodingEnabled(true);
        this.writeWireformat.setVersion(3);
        this.readWireformat.setVersion(3);
        this.writeWireformat.setMagic(MAGIC);
        this.readWireformat.setMagic(MAGIC);
        String value = (String)this.env.get("createnewconnection");
        if (value != null) {
            this.createNewConnection = new Boolean(value);
        }
        this.timeout = (value = (String)this.env.get("readtimeout")) != null ? new Integer(value) : new Integer(10000);
        value = (String)this.env.get("lookupMultiCluster");
        if (value != null) {
            this.lookupMulti = new Boolean(value);
        }
        this.createSocket();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return null;
    }

    public void bind(Name name, Object obj) throws NamingException {
    }

    public void bind(String name, Object obj) throws NamingException {
        String tlqName = name;
        if (obj instanceof Destination) {
            tlqName = ((Destination)obj).getName();
        } else if (obj instanceof String) {
            tlqName = (String)obj;
        } else {
            throw new NamingException("can not cast to destination or String ");
        }
        JndiRequest req = new JndiRequest();
        req.setRequestType(1);
        req.setRequestInfo(name + ":" + tlqName + "#");
        this.sendRcvJndiRequest(req);
    }

    public void close() throws NamingException {
        this.closeSocket();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    public Context createSubcontext(Name name) throws NamingException {
        return null;
    }

    public Context createSubcontext(String name) throws NamingException {
        return null;
    }

    public void destroySubcontext(Name name) throws NamingException {
    }

    public void destroySubcontext(String name) throws NamingException {
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public String getNameInNamespace() throws NamingException {
        return null;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return null;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return null;
    }

    public NamingEnumeration list(String name) throws NamingException {
        return null;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return null;
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return null;
    }

    public Object sendRcvJndiRequest(JndiRequest req) throws NamingException {
        StringRRResponse resp = (StringRRResponse)this.requestData(req);
        int result = resp.getResult();
        if (result < 0) {
            throw new NamingException(resp.getInfo());
        }
        return this.createAdminObject(resp.getInfo());
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        JndiRequest req = new JndiRequest();
        if (this.lookupMulti) {
            req.setRequestType(3);
        } else {
            req.setRequestType(0);
        }
        req.setRequestInfo(name);
        return this.sendRcvJndiRequest(req);
    }

    private Object createAdminObject(String info) throws NamingException {
        Properties props = new Properties();
        try {
            String[] contents;
            if (info.indexOf("ClusterQueueName") >= 0 && (contents = info.split("\\|")).length > 0) {
                Properties[] qProperties = new Properties[contents.length];
                for (int i = 0; i < contents.length; ++i) {
                    Properties p = new Properties();
                    p.load(new ByteArrayInputStream(contents[i].getBytes()));
                    qProperties[i] = p;
                }
                return JmsContextFactory.createClusterQueueByProperties(qProperties);
            }
            props.load(new ByteArrayInputStream(info.getBytes()));
            String facType = (String)props.get("FactoryType");
            if (facType != null && !facType.equals("")) {
                String jndiurl = (String)this.env.get("java.naming.provider.url");
                if (jndiurl != null && jndiurl.length() > 0) {
                    props.setProperty("java.naming.provider.url", jndiurl);
                }
                return JmsContextFactory.createConnectionFactoryByProperties(props);
            }
            String queueName = (String)props.get("JndiQueueName");
            if (queueName != null && !queueName.equals("")) {
                return JmsContextFactory.createQueueByProperties(props);
            }
            String topicName = (String)props.get("JndiTopicName");
            if (topicName != null && !topicName.equals("")) {
                return JmsContextFactory.createTopicByProperties(props);
            }
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
        return null;
    }

    public Object lookupLink(Name name) throws NamingException {
        return null;
    }

    public Object lookupLink(String name) throws NamingException {
        return null;
    }

    public void rebind(Name name, Object obj) throws NamingException {
    }

    public void rebind(String name, Object obj) throws NamingException {
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    public void rename(Name oldName, Name newName) throws NamingException {
    }

    public void rename(String oldName, String newName) throws NamingException {
    }

    public void unbind(Name name) throws NamingException {
    }

    public void unbind(String name) throws NamingException {
    }

    private void parseAndValidate(String addr) throws NamingException {
        logger.trace("provider url :{}", (Object)addr);
        this.addr = addr;
        String tmp = addr;
        String schemeName = "";
        int i = tmp.indexOf("://");
        if (i > 0) {
            schemeName = tmp.substring(0, i);
            tmp = tmp.substring(i + 3);
        }
        if (schemeName.equalsIgnoreCase("tlq") || schemeName.equalsIgnoreCase("tlkq") || schemeName.equalsIgnoreCase("http")) {
            i = tmp.indexOf(63);
            if (i >= 0) {
                tmp = tmp.substring(0, i);
            }
            if ((i = tmp.indexOf(47)) >= 0) {
                tmp = tmp.substring(0, i);
            }
            if ((i = tmp.lastIndexOf(58)) >= 0) {
                this.port = Integer.parseInt(tmp.substring(i + 1));
                tmp = tmp.substring(0, i);
            }
            this.addrHost = tmp;
            if (this.addrHost == null || this.addrHost.equals("")) {
                this.addrHost = DEFAULT_HOSTNAME;
            }
            if (this.port == -1) {
                this.port = 10025;
            }
        } else {
            throw new NamingException("Illegal address. Unknown address scheme : " + addr);
        }
    }

    private DataStructure requestData(DataStructure command) throws NamingException {
        if (this.socket == null && this.httpSocket == null) {
            this.createSocket();
        }
        DataStructure response = null;
        try {
            try {
                logger.trace("send a jndi request packet:{}", command);
                this.writeWireformat.marshal(command, this.os);
                response = (DataStructure)this.readWireformat.unmarshal(this.is);
                logger.trace("receive  a jndi response :{}", response);
            }
            catch (IOException e) {
                logger.trace("packet error:", e);
                NamingException ex = new NamingException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            Object var6_3 = null;
            if (this.createNewConnection) {
                this.closeSocket();
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (this.createNewConnection) {
                this.closeSocket();
            }
            throw throwable;
        }
        return response;
    }

    private void closeSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.is.close();
                this.os.close();
                this.socket = null;
            }
            if (this.httpSocket != null) {
                this.httpSocket.close();
                this.is.close();
                this.os.close();
                this.httpSocket = null;
            }
        }
        catch (IOException e) {
            logger.trace("close socket error:", e);
        }
    }

    private void throwException(Command response) throws NamingException {
        ExceptionResponse r = (ExceptionResponse)response;
        String reason = r.getException().getMessage();
        if (reason.indexOf("NOT FOUND") > 0) {
            throw new NameNotFoundException(reason);
        }
        NamingException ne = new NamingException();
        ne.initCause(r.getException());
        throw ne;
    }

    private void createSocket() throws NamingException {
        logger.trace("start create socket :host:[{}],port:[{}]", (Object)this.addrHost, (Object)new Integer(this.port));
        try {
            if (!this.addr.toLowerCase().startsWith("http")) {
                this.socket = new Socket(this.addrHost, this.port);
                if (this.timeout != null) {
                    this.socket.setSoTimeout(this.timeout);
                }
                this.os = new DataOutputStream(this.socket.getOutputStream());
                this.is = new DataInputStream(this.socket.getInputStream());
            } else {
                this.httpSocket = new HttpTunnelSocket(this.addr);
                if (this.timeout != null) {
                    this.httpSocket.setConnectionTimeout(this.timeout);
                }
                this.os = new DataOutputStream(this.httpSocket.getOutputStream());
                this.is = new DataInputStream(this.httpSocket.getInputStream());
            }
        }
        catch (IOException e) {
            logger.trace("create socket error:", e);
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
    }
}

