/*
 * Decompiled with CFR 0.152.
 */
package tongtech.jms.jndi;

import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tongtech.jms.jndi.TlqClusterFactoryRecord;
import tongtech.jms.jndi.TlqClusterQueueRecord;
import tongtech.jms.jndi.TlqFactoryRecord;
import tongtech.jms.jndi.TlqLocalJndiException;
import tongtech.jms.jndi.TlqLocalJndiSAX;

public class TlqLocalJndi {
    private String description;
    private Hashtable<String, TlqClusterFactoryRecord> clusterFactoryRecords = new Hashtable();
    private Hashtable<String, TlqClusterQueueRecord> clusterQueues = new Hashtable();
    private int g_lineno = 0;

    public TlqLocalJndi(String config) throws TlqLocalJndiException {
        try {
            Document doc = TlqLocalJndiSAX.readXml(config);
            NodeList clusterRecords = doc.getElementsByTagName("cluster-factory-record");
            if (clusterRecords.getLength() == 0) {
                throw new TlqLocalJndiException("can't find cluster-factory-record");
            }
            for (int i = 0; i < clusterRecords.getLength(); ++i) {
                String consumer_cache_size;
                Node clusterRecord = clusterRecords.item(i);
                if (clusterRecord.getNodeType() != 1) continue;
                Element clusterRecordElement = (Element)clusterRecord;
                TlqClusterFactoryRecord clusterFactory = new TlqClusterFactoryRecord();
                String cluster_factory_jndi_name = this.getElementText(clusterRecordElement, "cluster-factory-jndi-name");
                this.checkNotNull(cluster_factory_jndi_name, "cluster-factory-jndi-name");
                if (this.clusterFactoryRecords.containsKey(cluster_factory_jndi_name)) {
                    throw new TlqLocalJndiException("duplicated " + cluster_factory_jndi_name + " for " + "cluster-factory-jndi-name" + this.appendLineNo());
                }
                clusterFactory.setClusterFactoryJndiName(cluster_factory_jndi_name);
                String cluster_factory_type = this.getElementText(clusterRecordElement, "cluster-factory-type");
                this.checkNotNull(cluster_factory_type, "cluster-factory-type");
                this.checkValidQcf(cluster_factory_type);
                clusterFactory.setClusterFactoryType(cluster_factory_type);
                String reconnect_interval = this.getElementText(clusterRecordElement, "reconnect-interval");
                if (reconnect_interval != null) {
                    int i_reconnect_interval = this.checkInteger(reconnect_interval);
                    this.checkGreaterEqualThan(i_reconnect_interval, 0, "reconnect-interval");
                    clusterFactory.setReconnectInterval(i_reconnect_interval);
                }
                if ((consumer_cache_size = this.getElementText(clusterRecordElement, "consumer-cache-size")) != null) {
                    int i_consumer_cache_size = this.checkInteger(consumer_cache_size);
                    this.checkGreaterEqualThan(i_consumer_cache_size, 1, "consumer-cache-size");
                    clusterFactory.setConsumerCacheSize(i_consumer_cache_size);
                }
                this.clusterFactoryRecords.put(cluster_factory_jndi_name, clusterFactory);
                NodeList factoryRecords = clusterRecordElement.getElementsByTagName("factory-record");
                if (factoryRecords.getLength() == 0) {
                    throw new TlqLocalJndiException("can't find factory-record in " + cluster_factory_jndi_name);
                }
                List<TlqFactoryRecord> factoryList = clusterFactory.getFactoryRecords();
                for (int j = 0; j < factoryRecords.getLength(); ++j) {
                    String send_message_weight;
                    String producer_flow_limit;
                    String consumer_flow_thresshold;
                    String consumer_flow_limit;
                    String response_timeout;
                    Node factoryRecord = factoryRecords.item(j);
                    if (factoryRecord.getNodeType() != 1) continue;
                    Element factoryRecordElement = (Element)factoryRecord;
                    TlqFactoryRecord factory = new TlqFactoryRecord();
                    String remote_address = this.getElementText(factoryRecordElement, "remote-address");
                    this.checkNotNull(remote_address, "remote-address");
                    factory.setRemoteAddress(remote_address);
                    String ping_interval = this.getElementText(factoryRecordElement, "ping-interval");
                    if (ping_interval != null && !ping_interval.equals("")) {
                        int i_ping_interval = this.checkInteger(ping_interval);
                        this.checkGreaterEqualThan(i_ping_interval, 0, "ping-interval");
                        factory.setPingInterval(i_ping_interval);
                    }
                    if ((response_timeout = this.getElementText(factoryRecordElement, "response-timeout")) != null && !response_timeout.equals("")) {
                        int i_response_timeout = this.checkInteger(response_timeout);
                        this.checkGreaterEqualThan(i_response_timeout, 0, "response-timeout");
                        factory.setResponseTimeout(i_response_timeout);
                    }
                    if ((consumer_flow_limit = this.getElementText(factoryRecordElement, "consumer-flow-limit")) != null && !consumer_flow_limit.equals("")) {
                        int i_consumer_flow_limit = this.checkInteger(consumer_flow_limit);
                        this.checkGreaterEqualThan(i_consumer_flow_limit, 0, "consumer-flow-limit");
                        factory.setConsumerFlowlimit(i_consumer_flow_limit);
                    }
                    if ((consumer_flow_thresshold = this.getElementText(factoryRecordElement, "consumer-flow-threshold")) != null && !consumer_flow_thresshold.equals("")) {
                        int i_consumer_flow_thresshold = this.checkInteger(consumer_flow_thresshold);
                        this.checkGreaterEqualThan(i_consumer_flow_thresshold, 1, "consumer-flow-threshold");
                        factory.setConsumerFlowThreshold(i_consumer_flow_thresshold);
                    }
                    if ((producer_flow_limit = this.getElementText(factoryRecordElement, "producer-flow-bytes-limit")) != null && !producer_flow_limit.equals("")) {
                        int i_producer_flow_limit = this.checkInteger(producer_flow_limit);
                        this.checkGreaterEqualThan(i_producer_flow_limit, 1, "producer-flow-bytes-limit");
                        factory.setProducerFlowBytesLimit(i_producer_flow_limit);
                    }
                    if ((send_message_weight = this.getElementText(factoryRecordElement, "send-message-weight")) != null && !send_message_weight.equals("")) {
                        int i_send_message_weight = this.checkInteger(send_message_weight);
                        this.checkGreaterEqualThan(i_send_message_weight, 1, "send-message-weight");
                        factory.setSendMessageWeight(i_send_message_weight);
                    }
                    factory.setReconnectInterval(clusterFactory.getReconnectInterval());
                    factory.setConsumerCacheSize(clusterFactory.getConsumerCacheSize());
                    factory.setRecordId(j);
                    factoryList.add(factory);
                }
            }
            NodeList clusterQueueRecords = doc.getElementsByTagName("cluster-queue-record");
            if (clusterQueueRecords.getLength() == 0) {
                throw new TlqLocalJndiException("can't find cluster-queue-record");
            }
            for (int i = 0; i < clusterQueueRecords.getLength(); ++i) {
                Node clusterQueueRecord = clusterQueueRecords.item(i);
                if (clusterQueueRecord.getNodeType() != 1) continue;
                Element clusterQueueRecordElement = (Element)clusterQueueRecord;
                String cluster_queue_jndi_name = this.getElementText(clusterQueueRecordElement, "cluster-queue-jndi-name");
                this.checkNotNull(cluster_queue_jndi_name, "cluster-queue-jndi-name");
                if (this.clusterQueues.containsKey(cluster_queue_jndi_name)) {
                    throw new TlqLocalJndiException("duplicated " + cluster_queue_jndi_name + " for " + "cluster-queue-jndi-name");
                }
                String node_queue_name = this.getElementText(clusterQueueRecordElement, "node-queue-name");
                this.checkNotNull(node_queue_name, "node-queue-name");
                TlqClusterQueueRecord clusterQueue = new TlqClusterQueueRecord();
                clusterQueue.setClusterQueueJndiName(cluster_queue_jndi_name);
                clusterQueue.setNodeQueueName(node_queue_name);
                this.clusterQueues.put(cluster_queue_jndi_name, clusterQueue);
            }
        }
        catch (Exception e) {
            if (e instanceof TlqLocalJndiException) {
                throw (TlqLocalJndiException)e;
            }
            throw new TlqLocalJndiException(e.getMessage());
        }
    }

    public String getElementText(Element element, String tagName) {
        NodeList nodes = element.getElementsByTagName(tagName);
        if (nodes == null) {
            this.g_lineno = -1;
            return null;
        }
        if (nodes.getLength() == 0 || nodes.getLength() > 1) {
            this.g_lineno = -1;
            return null;
        }
        Node node = nodes.item(0);
        if (node == null) {
            this.g_lineno = -1;
            return null;
        }
        if (node.getNodeType() != 1) {
            this.g_lineno = -1;
            return null;
        }
        Element nodeElement = (Element)node;
        this.g_lineno = Integer.parseInt(nodeElement.getAttribute("lineNumber"));
        return nodeElement.getTextContent().trim();
    }

    public int getElementLineNo(Element element, String tagName) {
        NodeList nodes = element.getElementsByTagName(tagName);
        if (nodes == null) {
            return -1;
        }
        if (nodes.getLength() == 0 || nodes.getLength() > 1) {
            return -1;
        }
        Node node = nodes.item(0);
        if (node == null) {
            return -1;
        }
        if (node.getNodeType() != 1) {
            return -1;
        }
        Element nodeElement = (Element)node;
        return Integer.parseInt(nodeElement.getAttribute("lineNumber"));
    }

    public void setElementLineNo(Element element, String tagName) {
        Node node;
        NodeList nodes = element.getElementsByTagName(tagName);
        if (nodes == null) {
            this.g_lineno = -1;
        }
        if (nodes.getLength() == 0 || nodes.getLength() > 1) {
            this.g_lineno = -1;
        }
        if ((node = nodes.item(0)) == null) {
            this.g_lineno = -1;
        }
        if (node.getNodeType() != 1) {
            this.g_lineno = -1;
        }
        Element nodeElement = (Element)node;
        this.g_lineno = Integer.parseInt(nodeElement.getAttribute("lineNumber"));
    }

    public void checkMustExist(String result, String tagName) throws TlqLocalJndiException {
        if (result == null) {
            throw new TlqLocalJndiException("can't find " + tagName);
        }
    }

    public String appendLineNo() {
        if (this.g_lineno >= 0) {
            return ",lineno = " + this.g_lineno;
        }
        return "";
    }

    public void checkNotNull(String result, String tagName) throws TlqLocalJndiException {
        if (result == null || result.equals("")) {
            throw new TlqLocalJndiException("null value of " + tagName + " not allowed" + this.appendLineNo());
        }
    }

    public void checkSendMessageWeight(String result, String tagName) throws TlqLocalJndiException {
        int val = Integer.parseInt(result);
        if (val <= 0) {
            throw new TlqLocalJndiException("value of " + tagName + " should be greater than 0" + this.appendLineNo());
        }
    }

    public void checkValidQcf(String result) throws TlqLocalJndiException {
        String lowerResult = result.toLowerCase();
        String[] validQcf = new String[]{"cf", "qcf", "xacf", "xaqcf"};
        for (int i = 0; i < validQcf.length; ++i) {
            if (!lowerResult.equals(validQcf[i])) continue;
            return;
        }
        throw new TlqLocalJndiException(result + " is not valid for " + "cluster-factory-type" + this.appendLineNo());
    }

    public void checkValidClusterFactoryRef(String result) throws TlqLocalJndiException {
        if (!this.getClusterFactoryRecords().containsKey(result)) {
            throw new TlqLocalJndiException("can't find " + result + " in " + "cluster-factory-jndi-name" + this.appendLineNo());
        }
    }

    public int checkInteger(String result) throws TlqLocalJndiException {
        int res = -1;
        try {
            res = Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            throw new TlqLocalJndiException(result + " is not integer" + this.appendLineNo());
        }
        return res;
    }

    public void checkGreaterEqualThan(int num, int compareInt) throws TlqLocalJndiException {
        if (num < compareInt) {
            throw new TlqLocalJndiException(num + " is less than " + compareInt + this.appendLineNo());
        }
    }

    public void checkGreaterEqualThan(int num, int compareInt, String propName) throws TlqLocalJndiException {
        if (num < compareInt) {
            throw new TlqLocalJndiException(propName + " " + num + " is less than " + compareInt + this.appendLineNo());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Hashtable<String, TlqClusterFactoryRecord> getClusterFactoryRecords() {
        return this.clusterFactoryRecords;
    }

    public void setClusterFactoryRecords(Hashtable<String, TlqClusterFactoryRecord> clusterFactoryRecords) {
        this.clusterFactoryRecords = clusterFactoryRecords;
    }

    public Hashtable<String, TlqClusterQueueRecord> getClusterQueues() {
        return this.clusterQueues;
    }

    public void setClusterQueues(Hashtable<String, TlqClusterQueueRecord> clusterQueues) {
        this.clusterQueues = clusterQueues;
    }

    public TlqClusterFactoryRecord getClusterFactoryRecord(String clusterJndiName) {
        return this.clusterFactoryRecords.get(clusterJndiName);
    }

    public TlqClusterQueueRecord getClusterQueueRecord(String queueJndiName) {
        return this.clusterQueues.get(queueJndiName);
    }
}

