package com.tydic.bcm.personal.common.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题 BcmCostInfoBO
 * 说明 成本中心BO
 * 时间 2023/7/20 14:21
 *
 * @author 唐富强
 */
@Data
public class BcmCostInfoBO implements Serializable {
    private static final long serialVersionUID = -5218764541649746054L;
    private Long id;

    /**
     * 成本中心编号
     */
    private String costCenterCode;

    /**
     * 成本中心名称
     */
    private String costCenterName;

    /**
     * 成本中心id
     */
    private String costCenterId;

    /**
     * 财务机构编号
     */
    private String financialOrgCode;

    /**
     * 财务机构名称
     */
    private String financialOrgName;

    /**
     * 财务机构id
     */
    private String financialOrgId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新人id
     */
    private String updateUserId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 状态 0-停用 1-启用
     */
    private Integer status;

    /**
     * 状态翻译
     */
    private String statusStr;


    /**
     * 标识：1：新增；2：修改；3：删除
     */
    private Integer operType;
}
