package com.tydic.bcm.personal.common.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 类名： BcmBudgetModeConfigBO
 * 说明：预算模式设置--领域对象
 *
 * @author： lishiqing
 * 时间： 2023/7/24 9:50
 */
@Data
public class BcmBudgetModeConfigBO implements Serializable {
    private static final long serialVersionUID = 6121335031925528608L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 机构ID
     */
    private Long orgId;

    /**
     * 机构编码
     */
    private String orgCode;

    /**
     * 机构名称
     */
    private String orgName;

    /**
     * 财务机构编码
     */
    private String financeOrgCode;

    /**
     * 财务机构名称
     */
    private String financeOrgName;

    /**
     * 预算模式：
     * 0：未设置
     * 1：财务事项申请单
     * 2：成本中
     */
    private Integer budgetMode;

    /**
     * 预算模式翻译
     */
    private Integer budgetModeStr;

    /**
     * 创建人ID
     */
    private Long createUserId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人ID
     */
    private Long updateUserId;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新时间
     */
    private Date updateTime;
}
