package com.tydic.bcm.personal.common.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 类名： BcmPurchasePurposeInfoBO
 * 说明：我的采购用途--领域对象
 *
 * @author： lishiqing
 * 时间： 2023/7/25 10:08
 */
@Data
public class BcmPurchasePurposeInfoBO implements Serializable {
    private static final long serialVersionUID = -2622747776207452383L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 采购用途ID
     */
    private Long purchasePurposeId;

    /**
     * 采购用途名称
     */
    private String purchasePurposeName;

    /**
     * 收支项目ID
     */
    private Long paymentProjectId;

    /**
     * 收支项目名称
     */
    private String paymentProjectName;

    /**
     * 关联状态：
     * 1：已关联
     * 2：未关联
     * 3：收支项目失效
     */
    private Integer relStatus;

    /**
     * 关联状态翻译
     */
    private String relStatusStr;

    /**
     * 创建人ID
     */
    private Long createUserId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建人机构ID
     */
    private Long createOrgId;

    /**
     * 创建人机构名称
     */
    private String createOrgName;

    /**
     * 创建人公司ID
     */
    private Long createCompanyId;

    /**
     * 创建人公司名称
     */
    private String createCompanyName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人ID
     */
    private Long updateUserId;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新人机构ID
     */
    private Long updateOrgId;

    /**
     * 更新人机构名称
     */
    private String updateOrgName;

    /**
     * 更新人公司ID
     */
    private Long updateCompanyId;

    /**
     * 更新人公司名称
     */
    private String updateCompanyName;

    /**
     * 更新时间
     */
    private Date updateTime;

}
