package com.tydic.bcm.personal.commodity.bo;

import com.tydic.bcm.personal.common.bo.BcmFileBO;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 上架申请单明细BO
 *
 * @author : civism
 * @version 1.0
 * @date 2023/7/28 10:39
 */
@Data
public class BcmApplyCommodityOrderItemBO implements Serializable {
    private static final long serialVersionUID = -9054422447582525908L;

    /**
     * 商品名称
     */
    @NotBlank(message = "商品名称不能为空")
    private String commodityName;
    /**
     * 商品一级分类id
     */
    @NotNull(message = "商品一级分类id不能为空")
    private Long firstCatalogId;
    /**
     * 商品一级分类名称
     */
    @NotBlank(message = "商品一级分类名称不能为空")
    private String firstCatalogName;
    /**
     * 商品二级分类id
     */
    @NotNull(message = "商品二级分类id不能为空")
    private Long secondaryCatalogId;
    /**
     * 商品二级分类名称
     */
    @NotBlank(message = "商品二级分类名称不能为空")
    private String secondaryCatalogName;
    /**
     * 商品三级分类id
     */
    @NotNull(message = "商品三级分类id不能为空")
    private Long thirdCatalogId;
    /**
     * 商品三级分类名称
     */
    @NotBlank(message = "商品三级分类名称不能为空")
    private String thirdCatalogName;
    /**
     * 商品类型ID
     */
    @NotNull(message = "商品类型ID不能为空")
    private Long commodityTypeId;
    /**
     * 商品类型名称
     */
    @NotBlank(message = "商品类型名称不能为空")
    private String commodityTypeName;
    /**
     * 计量单位id
     */
    @NotNull(message = "计量单位id不能为空")
    private Long meterageUnitId;
    /**
     * 计量单位名称
     */
    @NotBlank(message = "计量单位名称不能为空")
    private String meterageUnitName;
    /**
     * 品牌id
     */
    private Long brandId;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 规格
     */
    @NotBlank(message = "规格不能为空")
    private String specs;
    /**
     * 型号
     */
    @NotBlank(message = "型号不能为空")
    private String modelNumber;
    /**
     * 需求数量
     */
    @NotNull(message = "需求数量不能为空")
    private Integer needNum;
    /**
     * 购买开始时段
     */
    @NotNull(message = "购买开始时段不能为空")
    private Date buyStartTime;
    /**
     * 购买结束时段
     */
    @NotNull(message = "购买结束时段不能为空")
    private Date buyEndTime;
    /**
     * 备注
     */
    private String remark;

    /**
     * 文件信息
     */
    private List<@Valid BcmFileBO> fileList;
}
