package com.tydic.bcm.personal.commodity.bo;

import com.tydic.bcm.personal.common.bo.BcmFileBO;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 标题 BcmAddReplyCommodityBO
 * 说明 应答商品明细BO
 * 时间 2023/8/1 18:00
 *
 * @author 唐富强
 */
@Data
public class BcmAddReplyCommodityBO implements Serializable {
    private static final long serialVersionUID = 1097412799378254020L;
    /**
     * 上架申请单id
     */
    private Long applyOrderId;

    /**
     * 上架申请单明细id
     */
    private Long applyOrderItemId;

    /**
     * 商品应答类型Id
     */
    private Integer commodityReplyTypeId;

    /**
     * 商品id
     */
    private Long skuId;

    /**
     * 商品编码
     */
    private String skuCode;

    /**
     * 商品名称
     */
    private String skuName;

    /**
     * 商品一级分类id
     */
    private Long firstCatalogId;
    /**
     * 商品一级分类名称
     */
    private String firstCatalogName;
    /**
     * 商品二级分类id
     */
    private Long secondaryCatalogId;
    /**
     * 商品二级分类名称
     */
    private String secondaryCatalogName;
    /**
     * 商品三级分类id
     */
    private Long thirdCatalogId;
    /**
     * 商品三级分类名称
     */
    private String thirdCatalogName;
    /**
     * 商品类型ID
     */
    private Long commodityTypeId;
    /**
     * 商品类型名称
     */
    private String commodityTypeName;
    /**
     * 计量单位id
     */
    private Long meterageUnitId;
    /**
     * 计量单位名称
     */
    private String meterageUnitName;
    /**
     * 品牌id
     */
    private Long brandId;
    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 供应数量
     */
    private Integer supplyNum;

    /**
     * 销售价格
     */
   private BigDecimal salePrice;

    /**
     * 附件集合
     */
   private List<BcmFileBO> fileInfo;
}
