package com.tydic.bcm.personal.commodity.bo;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 上架申请单添加BO
 *
 * @author : civism
 * @version 1.0
 * @date 2023/7/28 10:35
 */
@Data
public class BcmAddApplyCommodityOrderReqBO implements Serializable {
    private static final long serialVersionUID = 7130664596776925418L;

    /**
     * 上架申请单名称
     */
    @NotBlank(message = "上架申请单名称不能为空")
    private String applyOrderName;
    /**
     * 上架申请单状态：
     * 1：草稿；2：申请审批中；3：应答中；4：选定中；5：已选定
     * 6：结果审批中；7：已完成；8：已终止
     */
    @NotNull(message = "申请单状态不能为空")
    private Integer applyOrderStatus;
    /**
     * 采购单位id
     */
    @NotNull(message = "采购单位id不能为空")
    private Long purCompanyId;
    /**
     * 采购单位名称
     */
    @NotBlank(message = "采购单位名称不能为空")
    private String purCompanyName;
    /**
     * 联系电话
     */
    @NotBlank(message = "联系电话不能为空")
    private String applyUserPhone;

    /**
     * 发起人机构id
     */
    @NotNull(message = "发起人机构id不能为空")
    private Long applyUserOrgId;
    /**
     * 发起人机构名称
     */
    @NotBlank(message = "发起人机构名称不能为空")
    private String applyUserOrgName;
    /**
     * 发起人id
     */
    @NotNull(message = "发起人id不能为空")
    private Long applyUserId;
    /**
     * 发起人名称
     */
    @NotBlank(message = "发起人名称不能为空")
    private String applyUserName;
    /**
     * 发起人公司id
     */
    @NotNull(message = "发起人公司id不能为空")
    private Long applyUserCompanyId;
    /**
     * 发起人公司名称
     */
    @NotBlank(message = "发起人公司id不能为空")
    private String applyUserCompanyName;
    /**
     * 是否为定制商品0是1否
     */
    @NotNull(message = "是否为定制商品不能为空")
    private Integer isCustomizedFlag;

    /**
     * 应答期限（日）
     */
    @NotNull(message = "应答期限不能为空")
    private Integer replyDayLimit;

    /**
     * 创建人id
     */
    @NotNull(message = "创建人id不能为空")
    private Long userId;
    /**
     * 创建人名称
     */
    @NotBlank(message = "创建人用户名称不能为空")
    private String name;

    @Valid
    private BcmApplyCommodityOrderItemBO applyCommodityOrderItem;


}
