package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/1 10:02
 */
public enum BcmPersonalCommodityCancelTypeEnum {

    /**
     * 取消类型
     */
    APPLY_AUDIT_REJECT(1, "申请单审核驳回"),
    REPLY_DEADLINE(2, "截止应答期无回应"),
    REPLY_DEADLINE_UNSELECT(3, "截止应答期未选定商品"),
    SELECT_AUDIT_REJECT(4, "选定结果审核驳回"),
    NO_HITCH_COMMODITY(5, "已选定期限结束时申请单无挂接商品"),

    ;


    @Getter
    private final Integer cancelType;

    @Getter
    private final String cancelDesc;

    BcmPersonalCommodityCancelTypeEnum(Integer cancelType, String cancelDesc) {
        this.cancelType = cancelType;
        this.cancelDesc = cancelDesc;
    }
}
