package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/1 11:35
 */
public enum BpmApproveResultEnum {

    /**
     * 审批结果（pass：通过
     * <p>
     * reject：驳回
     * <p>
     * reSubmit：重新提交）
     */
    PASS("pass", "通过"),
    REJECT("reject", "驳回"),
    RESUBMIT("reSubmit", "重新提交"),

    ;


    @Getter
    private String approve;

    @Getter
    private String approveDesc;


    BpmApproveResultEnum(String approve, String approveDesc) {
        this.approve = approve;
        this.approveDesc = approveDesc;
    }
}
