package com.tydic.bcm.personal.settle.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题 BcmBondDeductInfoBO
 * 说明 保证金扣除申请信息BO
 * 时间 2023/7/25 09:59
 *
 * @author 唐富强
 */
@Data
public class BcmBondDeductInfoBO implements Serializable {


    private static final long serialVersionUID = 9185200625106457678L;
    private Long id;

    /**
     * 单据id
     */
    private Long docId;

    /**
     * 单据号
     */
    private String docCode;

    /**
     * 单据状态 1确认中2已拒绝3已确认
     */
    private Integer docStatus;

    /**
     * 单据状态翻译
     */
    private String docStatusStr;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 供应商code
     */
    private String supplierCode;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 扣款金额
     */
    private BigDecimal deductAmt;

    /**
     * 扣款事项
     */
    private String deductReason;


    /**
     * 确认人id
     */
    private Long confirmUserId;

    /**
     * 确认人姓名
     */
    private String confirmUserName;

    /**
     * 确认时间
     */
    private Date confirmTime;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新人id
     */
    private Long updateUserId;

    /**
     * 更新时间
     */
    private Date updateTime;
}
