package com.tydic.bcm.personal.commodity.bo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 类名： BcmQueryPendingAuditApplyCommodityOrderPageListReqBO
 * 说明：上架申请单-待审批列表查询（分页）--入参
 *
 * @author： lishiqing
 * 时间： 2023/8/1 9:56
 */
@Data
public class BcmQueryPendingAuditApplyCommodityOrderPageListReqBO extends BasePageReqBo {
    private static final long serialVersionUID = -3168616546619188226L;
    /**
     * 申请单名称
     */
    private String applyOrderName;

    /**
     * 申请单编号
     */
    private String applyOrderCode;

    /**
     * 采购单位
     */
    private String purCompanyName;

    /**
     * 提交人
     */
    private String applyUserName;

    /**
     * 提交开始时间
     */
    private Date createStartTime;

    /**
     * 提交结束时间
     */
    private Date createEndTime;

    /**
     * 截止应答开始时间
     */
    private Date replyDeadlineStartDate;

    /**
     * 截止应答结束时间
     */
    private Date replyDeadlineEndDate;

    /**
     * 任务状态
     */
    private Integer taskStatus;

    /**
     * 任务状态集合
     * 任务状态1待审核2已通过3已驳回4已取消
     */
    private List<Integer> taskStatusList;

    /**
     * 申请单类型（是否定制化） 0是1否
     */
    private Integer isCustomizedFlag;

    /**
     * 是否查询汇总数据 0是1否
     */
    private Integer sumFlag;

    /**
     * 流程类型：
     * 1：上架申请审批
     * 2：上架申请选定结果审批
     */
    private Integer flowType;

    /**
     * 待审人ID
     */
    private Long pendingAuditUserId;

    /**
     * 审批人ID
     */
    private Long auditUserId;
}
