package com.tydic.bcm.personal.common.bo;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 流程实例对象
 *
 * @author : civism
 * @version 1.0
 * @date 2023/7/31 14:15
 */
@Data
public class BcmFlowInstanceBO implements Serializable {
    private static final long serialVersionUID = 2373987558528180421L;

    /**
     * ID
     */
    private Long id;
    /**
     * 单据id
     */

    private Long objId;
    /**
     * 单据类型:
     * 1:上架申请单
     */
    private Integer objType;
    /**
     * 流程类型：
     * 1：上架申请审批
     * 2：上架申请选定结果审批
     */
    private Integer flowType;
    /**
     * 流程key
     */
    private String flowKey;
    /**
     * 流程定义id
     */
    private String flowDefId;
    /**
     * 流程实例id
     */
    @NotBlank(message = "流程实例id不能为空")
    private String flowInstId;
    /**
     * 当前节点编码
     */
    private String currentNodeCode;
    /**
     * 当前节点名称
     */
    private String currentNodeName;
    /**
     * 当前节点状态1审批中2已审批
     */
    private Integer currentNodeStatus;
    /**
     * 审批发起时间
     */
    private Date auditStartTime;
    /**
     * 审批结束时间
     */
    private Date auditEndTime;
    /**
     * 流程结束原因
     */
    private String auditEndReason;
    /**
     * 审批流是否结束：0:结束；1：未结束
     */
    private Integer isFinish;
    /**
     * 审批发起人id
     */
    private Long auditCreateUserId;
    /**
     * 审批发起人名称
     */
    private String auditCreateUserName;
    /**
     * 审批发起人机构id
     */
    private Long auditCreateOrgId;
    /**
     * 审批发起人机构名称
     */
    private String auditCreateOrgName;
    /**
     * 审批发起人公司id
     */
    private Long auditCreateCompanyId;
    /**
     * 审批发起人公司名称
     */
    private String auditCreateCompanyName;
    /**
     * 删除标志（0代表存在 1代表删除）
     */
    private Integer delFlag;

    /**
     * 流程任务
     */
    private List<BcmFlowTaskBO> bcmFlowTaskList;
}
