package com.tydic.bcm.personal.common.bo;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/2 18:08
 */
@Data
public class BcmUpdateFlowTaskReqBO implements Serializable {

    private static final long serialVersionUID = -559402638330417523L;

    /**
     * 流程是否结束
     */
    private Integer flowFinishFlag;

    /**
     * 主键id
     */
    private Long flowInstanceId;
    /**
     * 任务id
     */
    @NotNull(message = "taskId不能为空")
    private String taskId;
    /**
     * 流程实例id
     */
    private String flowInstId;
    /**
     * 当前节点编码
     */
    private String currentNodeCode;
    /**
     * 当前节点名称
     */
    private String currentNodeName;
    /**
     * 待审批人id
     */
    private Long pendingAuditUserId;
    /**
     * 待审批人名称
     */
    private String pendingAuditUserName;
    /**
     * 待审批人机构id
     */
    private Long pendingAuditOrgId;
    /**
     * 待审批人机构名称
     */
    private String pendingAuditOrgName;
    /**
     * 待审批人公司id
     */
    private Long pendingAuditCompanyId;
    /**
     * 待审批人公司名称
     */
    private String pendingAuditCompanyName;
    /**
     * 任务状态1待审核2已通过3已驳回4已取消
     */
    private Integer taskStatus;
    /**
     * 审批人id
     */
    private Long auditUserId;
    /**
     * 审批人名称
     */
    private String auditUserName;
    /**
     * 审批人机构id
     */
    private Long auditOrgId;
    /**
     * 审批人机构名称
     */
    private String auditOrgName;
    /**
     * 审批人公司id
     */
    private Long auditCompanyId;
    /**
     * 审批人公司名称
     */
    private String auditCompanyName;
    /**
     * 审批时间
     */
    private Date auditTime;
    /**
     * 任务创建时间
     */
    private Date taskCreateTime;
    /**
     * 驳回原因
     */
    private String rejectReason;
    /**
     * 删除标志（0代表存在 1代表删除）
     */
    private Integer delFlag;
    /**
     * 更新者id
     */
    private Long updateUserId;
    /**
     * 更新者名称
     */
    private String updateUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
}
