package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/1 19:03
 */
public enum BcmFlowTaskStatusEnum {


    /**
     * 任务状态1待审核2已通过3已驳回4已取消
     */
    WAIT_APPROVE(1, "待审核"),
    PASS(2, "已通过"),
    REJECT(3, "已驳回"),
    CANCEL(4, "已取消"),
    STOP(5,"已终止"),
    RECALL(6,"已撤回"),
    ;

    @Getter
    private Integer taskStatus;


    @Getter
    private String taskStatusDesc;

    BcmFlowTaskStatusEnum(Integer taskStatus, String taskStatusDesc) {
        this.taskStatus = taskStatus;
        this.taskStatusDesc = taskStatusDesc;
    }
}
