package com.tydic.bcm.personal.constants;

import com.google.common.collect.ImmutableMap;

import java.util.Map;

/**
 * 描述: 〈交行公用模块个性化功能常量类〉
 * @author : yuhao
 * @date : 2023/7/19 15:49
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public class BcmPersonalCommonConstant {

    /**
     * 操作标识
     */
    public static final class OperType{
        /**
         * 新增
         */
        public static final Integer ADD = 1;

        /**
         * 修改
         */
        public static final Integer UPDATE = 2;

        /**
         * 删除
         */
        public static final Integer DEL = 3;
    }


    /**
     * 是否删除标识
     */
    public static final class DelFlag {
        /**
         * 生效
         */
        public static final Integer NO = 0;

        /**
         * 已删除
         */
        public static final Integer YES = 1;
    }

    /**
     * 是否标识
     */
    public static final class YesOrNo {
        /**
         * 是
         */
        public static final Integer YES = 0;

        /**
         * 否
         */
        public static final Integer NO = 1;

        /**
         * 是否标识Map
         */
        public static final Map<Integer,String> YesOrNoMap = ImmutableMap.of(0,"是",1,"否");

    }

    /**
     * 关联操作类型
     */
    public static final class RelOperType {
        /**
         * 关联
         */
        public static final Integer REL = 1;

        /**
         * 解除关联
         */
        public static final Integer NO_REL = 2;
    }

    /**
     * 关联状态
     */
    public static final class RelStatus {
        /**
         * 已关联
         */
        public static final Integer ASSOCIATED = 1;

        /**
         * 未关联
         */
       public static final Integer UNASSOCIATED = 2;

       /**
        * 收支项目失效
        */
        public static final Integer PAYMENT_PROJECT_EXP = 3;

        /**
         * 关联状态Map
         */
        public static final Map<Integer,String> RelStatusMap = ImmutableMap.of(1,"已关联",2,"未关联",3,"收支项目失效");
    }

    /**
     * 预算模式
     */
    public static final class BudgetMode {
        /**
         * 未设置
         */
        public static final Integer NOT_SET = 0;

        /**
         * 财务事项申请单
         */
        public static final Integer FINANCIAL_MATTERS_APPLICATION_FORM = 1;

        /**
         * 成本中心
         */
        public static final Integer COST_CENTER = 2;

        /**
         * 预算模式Map
         */
        public static final Map<Integer, String> BudgetModeMap = ImmutableMap.of(0, "未设置", 1, "财务事项申请单", 2, "成本中心");

    }

    /**
     * 通用状态
     */
    public static final class Status {

        /**
         * 启用
         */
        public static final Integer ENABLE = 1;

        /**
         * 启用翻译
         */
        public static final String ENABLE_STR = "启用";


        /**
         * 停用
         */
        public static final Integer DISABLE = 0;

        /**
         * 停用翻译
         */
        public static final String DISABLE_STR = "停用";


    }

    /**
     * 单据类型
     */
    public static final class BusinessType{


        /**
         * 1:上架申请明细单
         */
        public static final Integer APPLY_ORDER_ITEM = 1;

        /**
         * 2：供应商应答明细单
         */
        public static final Integer REPLY_ORDER_ITEM = 2;


        /**
         * 建议
         */
        public static final Integer SUGGESTION = 3;
    }

    /**
     * 是否匿名
     */
    public static class IsAnonymous{
        /**
         * 是
         */
        public static final Integer YES = 0;

        /**
         * 否
         */
        public static final Integer NO = 1;
    }

    /**
     * 建议单处理状态
     */
    public static final class SuggestedDealStatus {
        /**
         * 未处理
         */
        public static final Integer UNTREATED = 0;

        /**
         * 已处理
         */
        public static final Integer PROCESSED = 1;
    }


    /**
     * 建议栏目
     */
    public static final class SuggestedColumn {

        /**
         * 业务交流
         */
        public static final Integer BUSINESS_EXCHANGE = 1;

        public static final String BUSINESS_EXCHANGE_STR = "业务交流";

        /**
         * 问题反馈
         */
        public static final Integer PROBLEM_FEEDBACK = 2;

        public static final String PROBLEM_FEEDBACK_STR = "问题反馈";

        /**
         * 系统优化建议
         */
        public static final Integer SYSTEM_SUGGESTION = 3;

        public static final String SYSTEM_SUGGESTION_STR = "系统优化建议";

        /**
         * 集中采购违规问题反馈
         */
        public static final Integer VIOLATION_FEEDBACK = 4;

        public static final String VIOLATION_FEEDBACK_STR = "集中采购违规问题反馈";


    }

    /**
     * 处理状态
     */
    public static final class DealStatus {

        /**
         * 未处理
         */
        public static final Integer UNTREATED = 0;

        public static final String UNTREATED_STR = "未处理";

        /**
         * 已处理
         */
        public static final Integer PROCESSED = 1;

        public static final String PROCESSED_STR = "已处理";

    }

    /**
     * 处理结果
     */
    public static final class DealResult {
        /**
         * 同步成功
         */
        public static final String SUCCESS = "SUCCESS";

        /**
         * 同步失败
         */
        public static final String FAIL = "FAIL";

        /**
         * 无需同步
         */
        public static final String SKIP = "SKIP";

        /**
         * 待同步
         */
        public static final String PENDING = "PENDING";

    }

    /**
     * 原始启用状态
     */
    public static final class SourceStatus {
        /**
         * 启用
         */
        public static final Integer ENABLE = 2;

        /**
         * 停用
         */
        public static final Integer DISABLE = 3;
    }

    /**
     * 同步比对任务数据类型
     */
    public static final class SyncLogDataType {

        /**
         * 组织
         */
        public static final String NC_ORG = "NC_ORG";

        /**
         * 基础数据类型:
         * GUWP_USER:GUWP用户表
         * GUWP_ORG:GUWP机构表
         * NC_ORG：财务组织表
         * IPMP_SUPPLIER：智采供应商表
         * IPMP_SUPPLIER_USER：智采供应商
         * IPMP_SUPPLIER_BANK：智采供应商银行
         */

        /**
         * GUWP用户表
         */
        public static final String GUWP_USER = "GUWP_USER";

        /**
         * GUWP机构表
         */
        public static final String GUWP_ORG = "GUWP_ORG";

        /**
         * 智采供应商表
         */
        public static final String IPMP_SUPPLIER = "IPMP_SUPPLIER";

        /**
         * 智采供应商
         */
        public static final String IPMP_SUPPLIER_USER = "IPMP_SUPPLIER_USER";

        /**
         * 智采供应商
         */
        public static final String IPMP_SUPPLIER_BANK = "IPMP_SUPPLIER_BANK";

        /**
         * 智采合同
         */
        public static final String IPMP_CONTRACT = "IPMP_CONTRACT";

        /**
         * 付款记录
         */
        public static final String PAYMENT_RECORD = "PAYMENT_RECORD";
    }

    /**
     * 当前登录身份
     */
    public static final class LoginTagIn {
        /**
         * 运营
         */
        public static final String OPER = "0";
        /**
         * 采购
         */
        public static final String PURCHASE = "1";
        /**
         * 供应商
         */
        public static final String SUPPLIER = "2";
    }


    /**
     * 企业类别
     */
    public static final class OrgClass {

        /**
         * 内部企业
         */
        public static final String INTRANET = "4";
    }

    /**
     * 常量字符
     */
    public static final class Str {

        /**
         * 连接符
         */
        public static final String CONNECTOR = "-";
    }

    /**
     * 默认用户
     */
    public static final class DefaultUser {

        /**
         * 默认用户id
         */
        public static final Long DEFAULT_USER_ID = 1L;

        /**
         * 默认用户名
         */
        public static final String DEFAULT_USER_NAME = "系统管理员";
    }

    /**
     * 是否推送商品池
     */
    public static final class IsPushCommodityPool {

        /**
         * 未推送
         */
        public static final Integer NOT_PUSHED = 0;

        /**
         * 已推送
         */
        public static final Integer PUSHED = 1;

        /**
         * 已失效
         */
        public static final Integer BECAME_INVALID = 2;

    }
}
