package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * 交行合同状态
 *
 * @author : civism
 * @version 1.0
 * @date 2023/8/21 15:15
 */
public enum ContractStatusEnum {

    /**
     * 合同状态
     */
    NEW("00", "新建", null),
    AUDIT_ING("01", "法审中", null),
    TRANSFER_ING("03", "移交中", null),
    TRANSFERRED("04", "已移交", null),
    RECEIVED("05", "已接收", null),
    PERFORMANCE_ING("06", "履约中", null),
    PERFORMANCE_COMPLETION("07", "履约完成", null),
    EXIST_ERROR("08", "存在异常", null),
    CHANGE_ING("09", "变更中", null),
    CHANGE_COMPLETION("10", "变更完成", 9),
    RENEWAL_ING("11", "续约中", null),
    FINISH("12", "续约完成", 10),
    CANCEL("13", "作废", 8),


    ;

//    合同状态:00-新建；01-法审中；03-移交中；04-已移交；05-已接收
//06-履约中；07-履约完成；08-存在异常；09-变更中；10-变更完成
//11-续约中；12-续约完成；13-作废


    /**
     * 交行合同状态
     */
    @Getter
    private String contractStatus;

    /**
     * 交行合同状态描述
     */
    @Getter
    private String statusDesc;

    /**
     * 迪易采协议状态
     */
    @Getter
    private Integer mappingStatus;


    ContractStatusEnum(String contractStatus, String statusDesc, Integer mappingStatus) {
        this.contractStatus = contractStatus;
        this.statusDesc = statusDesc;
        this.mappingStatus = mappingStatus;
    }
}
