package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/25 14:09
 */
public enum DycBusiCodeEnum {
    /**
     * 代办标识
     */
    SYNC_TODO("syncTodo", "代办", 0),
    SYNC_DONE("syncDone", "已办", 2),
    TODO_REVOKE("todoRevoke", "撤回", 1),
    ;

    @Getter
    private String code;

    @Getter
    private String codeDesc;

    @Getter
    private Integer processStatus;


    DycBusiCodeEnum(String code, String codeDesc, Integer processStatus) {
        this.code = code;
        this.codeDesc = codeDesc;
        this.processStatus = processStatus;
    }


    public static DycBusiCodeEnum getByCode(String code) {
        DycBusiCodeEnum[] values = values();
        for (DycBusiCodeEnum dycBusiCodeEnum : values) {
            if (dycBusiCodeEnum.getCode().equals(code)) {
                return dycBusiCodeEnum;
            }
        }
        return null;
    }
}
