package com.tydic.bcm.personal.commodity.bo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 标题 BcmQueryApplyCommodityOrderPageListReqBO
 * 说明 上架申请单-列表查询（分页）入参
 * 时间 2023/7/31 14:18
 *
 * @author 唐富强
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BcmQueryApplyCommodityOrderPageListReqBO extends BasePageReqBo {


    private static final long serialVersionUID = 1438328367825828410L;
    /**
     * 上架申请单名称
     */
    private String applyOrderName;

    /**
     * 上架申请单编码
     */
    private String applyOrderCode;

    /**
     * 采购单位id
     */
    private Long purCompanyId;
    /**
     * 采购单位名称
     */
    private String purCompanyName;

    /**
     * 发起人id
     */
    private Long applyUserId;
    /**
     * 发起人名称
     */
    private String applyUserName;

    /**
     * 提交开始时间
     */
    private Date createStartTime;

    /**
     * 提交结束时间
     */
    private Date createEndTime;

    /**
     * 0是1否
     * 申请单类型（是否定制化）
     */
    private Integer isCustomizedFlag;

    /**
     * 截止应答开始时间
     */
    private Date replyDeadlineStartDate;

    /**
     * 截止应答结束时间
     */
    private Date replyDeadlineEndDate;

    /**
     * 选定截止日期开始时间
     */
    private Date selectDeadlineStartDate;

    /**
     * 选定截止日期结束时间
     */
    private Date selectDeadlineEndDate;

    /**
     * 申请单状态
     */
    private Integer applyOrderStatus;

    /**
     * 申请单状态集合
     */
    private List<Integer> applyOrderStatusList;

    /**
     * 终止原因类型
     */
    private Integer cancelType;

    /**
     * 发起人公司id
     */
    private Long applyUserCompanyId;

    /**
     * 是否查询汇总数据 0是1否(为0时才会查询统计字段)
     */
    private Integer sumFlag;

    /**
     * 挂接商品截止日期
     */
    private Date hitchDeadlineEndDate;
    /**
     * 挂接商品开始日期
     */
    private Date hitchDeadlineStartDate;

    /**
     * 是否挂接对应的上架申请单状态
     */
    private List<Integer> hitchFlagStatusList;

    /**
     * 发起人机构id
     */
    private Long applyUserOrgId;

}
