package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * 标题 BcmDealResultEnum
 * 说明 处理结果
 * 时间 2023/8/15 11:36
 *
 * @author 唐富强
 */
public enum BcmDealResultEnum {

    SUCCESS("SUCCESS", "同步成功"),
    FAIL("FAIL", "同步失败"),
    SKIP("SKIP", "无需同步"),
    PENDING("PENDING", "待同步");

    @Getter
    private String dealResult;


    @Getter
    private String dealRequestStr;

    BcmDealResultEnum(String dealResult, String dealRequestStr) {
        this.dealResult = dealResult;
        this.dealRequestStr = dealRequestStr;
    }

    /**
     * 状态翻译获取
     *
     * @param dealResult
     * @return
     */
    public static String getDealResultStr(String dealResult) {
        BcmDealResultEnum[] values = BcmDealResultEnum.values();
        for (BcmDealResultEnum dealResultEnum : values) {
            if (dealResultEnum.getDealResult().equals(dealResult)) {
                return dealResultEnum.getDealRequestStr();
            }
        }
        return null;
    }
}
