package com.tydic.bcm.personal.constants;

import com.google.common.collect.ImmutableMap;

import java.util.Map;

/**
 * 描述: 〈交行商品模块个性化功能常量类〉
 * @author : yuhao
 * @date : 2023/7/19 15:49
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public class BcmPersonalCommodityConstant {

    public static final String ApplyOrderCodePrefix="SJSQ";

    /**
     * 结算单状态常量
     */
    public static class SettleStatus{
        /**
         * 通过
         */
        public static String PASS = "1";

        /**
         * 驳回
         */
        public static String REJECT = "2";

    }


    /**
     * 删除标识
     */
    public static class DelFlag{

        /**
         * 已删除
         */
        public static final Integer YES = 1;

        /**
         * 未删除
         */
        public static final Integer NO = 0;
    }

    /**
     * 全局默认
     */
    public static final class GlobalFlag {
        /**
         * 是
         */
        public static final Integer YES = 0;

        /**
         * 否
         */
        public static final Integer NO = 1;
    }

    /**
     * 选定结果
     */
    public static final class SelectFlag {
        /**
         * 已选定
         */
        public static final Integer YES = 0;

        /**
         * 未选定
         */
        public static final Integer NO = 1;
    }

    /**
     * 选定结果
     */
    public static final class PushFlag {
        /**
         * 未推送
         */
        public static final Integer NO_PUSH = 1;

        /**
         * 已推送
         */
        public static final Integer YES_PUSH = 2;
    }


    /**
     * 	是否查询应答明细数据
     */
    public static final class QueryReplyFlag{
        /**
         * 是
         */
        public static final Integer YES = 0;

        /**
         * 否
         */
        public static final Integer NO = 1;
    }

    /**
     * 	是否查询任务明细
     */
    public static final class QueryTaskFlag{
        /**
         * 是
         */
        public static final Integer YES = 0;

        /**
         * 否
         */
        public static final Integer NO = 1;
    }

    /**
     * 任务状态
     */
    public static final class TaskStatus {
        /**
         * 待审核
         */
        public static final Integer PENDING_APPROVAL = 1;

        /**
         * 已通过
         */
        public static final Integer PASSED = 2;

        /**
         * 已驳回
         */
        public static final Integer REJECTED = 3;

        /**
         * 已取消
         */
        public static final Integer CANCELED = 4;

        /**
         * 任务状态Map
         */
        public static final Map<Integer,String> TaskStatusMap =
                ImmutableMap.of(1,"待审核",2,"已通过",3,"已驳回",4,"已取消");

   }

    /**
     * 商品应答类型I
     */
    public static final class CommodityReplyTypeId{
        /**
         * 挂接商品
         */
        public static final Integer HITCH =1;

        /**
         * 商品信息
         */
        public static final Integer GOODS =2;
    }

    /**
     * 操作类型
     */
    public static final class OperType{

        /**
         * 保存
         */
        public static final Integer SAVE =1;

        /**
         * 提交
         */
        public static final Integer SUBMIT =2;
    }

}
