package com.tydic.bcm.personal.task.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题 BcmUmcOrgInfoSyncTempBo
 * 说明 机构同步比对任务能力平台入参BO
 * 时间 2023/8/16 16:54
 *
 * @author 唐富强
 */
@Data
public class BcmOrgInfoSyncTempBo implements Serializable {


    private static final long serialVersionUID = -486484301593153438L;
    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * 机构类型 2公司 3部门 5外部客商
     */
    private Long orgType;

    /**
     * 机构编码
     */
    private String orgCode;

    /**
     * 上级机构编码，若上级机构为顶级传root，供应商机构默认传wbks
     */
    private String parentCode;

    /**
     * 外部机构ID
     */
    private String extOrgId;

    /**
     * 外部机构编码
     */
    private String extOrgCode;

    /**
     * 机构深度；层级
     */
    private String deep;

    /**
     * 机构名称
     */
    private String orgName;

    /**
     * 机构简称
     */
    private String orgAlias;

    /**
     * 是否虚拟；0是 1否
     */
    private String isVirtual;

    /**
     * 状态；1 启用 0 停用
     */
    private String orgStatus;

    /**
     * 排序
     */
    private Integer orgSort;

    /**
     * 删除标记;0生效 1已删除
     */
    private String delFlag;

    /**
     * 企业简称
     */
    private String orgShortName;

    /**
     * 企业性质
     */
    private String orgNature;

    /**
     * 是否客商;是否客商： 0 是 1 否
     */
    private String isMerchant;

    /**
     * 身份 0运营 1采购 2供应商
     */
    private String isProfess;

    /**
     * 是否铺货单位
     */
    private String isShopOrg;

    /**
     * 是否需要创建默认账套 1是 0否
     */
    private Integer isCreateDefaultAccount;

    /**
     * 国家
     */
    private String country;

    /**
     * 省份
     */
    private String province;

    /**
     * 地市
     */
    private String city;

    /**
     * 区县
     */
    private String county;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 所属行业
     */
    private String industry;

    /**
     * 联系电话
     */
    private String telephone;

    /**
     * 联系人
     */
    private String linkMan;

    /**
     * 传真
     */
    private String fax;

    /**
     * 邮箱
     */
    private String mailBox;

    /**
     * 法定代表人
     */
    private String legalPerson;

    /**
     * 法定代表人的证件号码
     */
    private String legalPersonCertNo;

    /**
     * 组织代码机构
     */
    private String orgCertificateCode;

    /**
     * 税务登记号
     */
    private String taxNo;

    /**
     * 社会信用代码
     */
    private String creditNo;

    /**
     * 营业执照
     */
    private String businessLicense;

    /**
     * 营业执照有效期开始日期
     */
    private Date businessIicenseStartDate;

    /**
     * 营业执照有效期结束日期
     */
    private Date businessLicenseEndDate;

    /**
     * 经营范围
     */
    private String businessScope;

    /**
     * 创建人
     */
    private Long createOperOd;

    /**
     * 创建人名称
     */
    private String createOperName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private Long updateOperId;

    /**
     * 修改人名称
     */
    private String updateOperName;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 数据同步时间
     */
    private Date syncTime;

    /**
     * 企业类别;1 外部个人 2 外部企业 4 内部企业
     */
    private String orgClass;

    /**
     * 排序
     */
    private String orderBy;

    /**
     * 同步扩展字段
     */
    private List<BcmSyncExtBo> umcSyncExtBoList;

}
