package com.tydic.bcm.personal.constants;

/**
 * 标题 BcmPersonalFlowConstant
 * 说明 流程常量类
 * 时间 2023/8/29 11:23
 *
 * @author 唐富强
 */
public class BcmPersonalFlowConstant {

    /**
     * 对象类型
     */
    public final static class ObjType {

        /**
         * 上架申请单
         */
        public static final Integer APPLY_ORDER = 1;
    }

    /**
     * 审批流是否结束
     */
    public final static class IsFinish {

        /**
         * 结束
         */
        public static final Integer YES = 0;

        /**
         * 未结束
         */
        public static final Integer NO = 1;

    }

    /**
     * 任务状态
     */
    public final static class TaskStatus {

        /**
         * 待审批
         */
        public static final Integer PENDING_APPROVAL = 1;

        /**
         * 已通过
         */
        public static final Integer ALREADY_PASSED = 2;

        /**
         * 已驳回
         */
        public static final Integer REJECTED = 3;

        /**
         * 已取消
         */
        public static final Integer CANCELLED = 4;

    }
}
