package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * 标题 BcmPersonalIsCustomizedFlagEnum
 * 说明 是否定制商品
 * 时间 2023/8/1 18:30
 *
 * @author 唐富强
 */
public enum BcmPersonalIsCustomizedFlagEnum {

    /**
     * 是否定制商品
     */
    YES(0, "定制商品"),
    IN_APPROVAL(1, "提需商品"),
    ;

    @Getter
    private final Integer status;

    @Getter
    private final String desc;

    BcmPersonalIsCustomizedFlagEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }


    /**
     * 状态翻译获取
     * @param status
     * @return
     */
    public static String getStatusDesc(Integer status) {
        BcmPersonalIsCustomizedFlagEnum[] values = BcmPersonalIsCustomizedFlagEnum.values();
        for (BcmPersonalIsCustomizedFlagEnum isCustomizedFlag : values) {
            if (isCustomizedFlag.getStatus().equals(status)) {
                return isCustomizedFlag.getDesc();
            }
        }
        return null;
    }
}
