package com.tydic.bcm.personal.address.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class BcmAddRelaAddressGroupReqBO implements Serializable {
    private static final long serialVersionUID = 9107288183502984327L;
    /**
     * 操作类型：
     * 1 新增
     * （operType为1时，groupId、addressId必填）
     * 2 按组id修改
     * （operType为2时，groupId必填）
     * 3 按地址id修改
     * （operType为3时，addressId必填）
     * 4 删除
     * （operType为4时，groupId、addressId至少填一个）
     */
    private Integer operType;
    /**
     * 地址分组id
     */
    private Long groupId;
    /**
     * 地址id
     */
    private Long addressId;
    /**
     * 关系列表
     * （有需要新建立的关联关系就放在这里面，否则这个字段就空着）
     */
    private List<BcmRelaAddressGroupBO> relInfoList;
    /**
     * 创建人id
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建时间
     */
    private Date createTime;
}
