package com.tydic.bcm.personal.commodity.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 标题 BcmQueryApplyOrderRspBO
 * 说明 查询上架申请单id
 * 时间 2023/8/29 11:03
 *
 * @author 唐富强
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class BcmQueryApplyOrderRspBO extends BaseRspBo {


    private static final long serialVersionUID = -736602029569128279L;
    /**
     * ID
     */
    private Long id;
    /**
     * 上架申请单Id
     */
    private Long applyOrderId;
    /**
     * 上架申请单编号
     */
    private String applyOrderCode;
    /**
     * 上架申请单名称
     */
    private String applyOrderName;
    /**
     * 上架申请单状态：
     * 1：草稿；2：申请审批中；3：应答中；4：选定中；5：已选定
     * 6：结果审批中；7：已完成；8：已终止
     */
    private Integer applyOrderStatus;
    /**
     * 采购单位id
     */
    private Long purCompanyId;
    /**
     * 采购单位名称
     */
    private String purCompanyName;
    /**
     * 联系电话
     */
    private String applyUserPhone;
    /**
     * 是否为定制商品0是1否
     */
    private Integer isCustomizedFlag;
    /**
     * 挂接商品截止日期
     */
    private Date hitchDeadlineDate;
    /**
     * 选定截止日期
     */
    private Date selectDeadlineDate;
    /**
     * 应答截止日期
     */
    private Date replyDeadlineDate;
    /**
     * 应答期限（日）
     */
    private Integer replyDayLimit;
    /**
     * 发起人机构id
     */
    private Long applyUserOrgId;
    /**
     * 发起人机构名称
     */
    private String applyUserOrgName;
    /**
     * 发起人id
     */
    private Long applyUserId;
    /**
     * 发起人名称
     */
    private String applyUserName;
    /**
     * 发起人公司id
     */
    private Long applyUserCompanyId;
    /**
     * 发起人公司名称
     */
    private String applyUserCompanyName;
    /**
     * 取消类型
     */
    private Integer cancelType;
    /**
     * 取消原因
     */
    private String cancelReason;
    /**
     * 是否推送商品池
     */
    private Integer isPushCommodityPool;
    /**
     * 删除标志（0代表存在 1代表删除）
     */
    private Integer delFlag;
    /**
     * 创建人id
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新人id
     */
    private Long updateUserId;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 上架申请单审批通过时间
     */
    private Date applyApprovePassTime;

    /**
     * 选定审核通过时间
     */
    private Date selectApprovePassTime;

}
