package com.tydic.bcm.personal.constants;

import lombok.Getter;

/**
 * 标题 BcmPerSonalCommonStatus
 * 说明 通用状态
 * 时间 2023/7/31 11:50
 *
 * @author 唐富强
 */
public enum BcmPersonalCommonStatusEnum {


    /**
     * 通用状态
     */
    YES(0, "是"),
    NO(1, "否"),
    ;

    @Getter
    private final Integer status;

    @Getter
    private final String desc;

    BcmPersonalCommonStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }


    /**
     * 状态翻译获取
     * @param status
     * @return
     */
    public static String getStatusDesc(Integer status) {
        BcmPersonalCommonStatusEnum[] values = BcmPersonalCommonStatusEnum.values();
        for (BcmPersonalCommonStatusEnum commonStatus : values) {
            if (commonStatus.getStatus().equals(status)) {
                return commonStatus.getDesc();
            }
        }
        return null;
    }
}
