package com.tydic.bcm.personal.constants;

/**
 * 描述: 〈交行结算模块个性化功能常量类〉
 * @author : yuhao
 * @date : 2023/7/19 15:49
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public class BcmPersonalSettleConstant {

    /**
     * 是否删除标识
     */
    public static final class DelFlag {
        /**
         * 生效
         */
        public static final Integer NO = 0;

        /**
         * 已删除
         */
        public static final Integer YES = 1;
    }

    /**
     * 保证申请单状态
     */
    public static final class BondDeductStatus{

        /**
         * 确认中
         */
        public static final Integer CONFIRMING = 1;

        /**
         * CONFIRMING 翻译
         */
        public static final String  CONFIRMING_STR = "确认中";

        /**
         * 已拒绝
         */
        public static final Integer DECLINED = 2;

        /**
         * DECLINED 翻译
         */
        public static final String DECLINED_STR = "已拒绝";

        /**
         * 已确认
         */
        public static final Integer CONFIRMED = 3;

        /**
         * CONFIRMED 翻译
         */
        public static final String CONFIRMED_STR = "已确认";
    }


    /**
     * 保证金扣除申请单操作类型
     */
    public static final class ConfirmBondDeductOperType{

        /**
         * 确认
         */
        public static final Integer VERIFY = 0;

        /**
         * 拒绝
         */
        public static final Integer REJECT = 1;
    }

    /**
     * 付款结果
     */
    public static final class PayResult {
        /**
         * 成功
         */
        public static final String SUCCESS = "1";

        /**
         * 失败
         */
        public static final String FAIL = "0";

    }
}
