package com.tydic.bcm.personal.task.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题 BcmFscPayInfoBackAbilityReqBO
 * 说明 付款信息回传服务Api入参
 * 时间 2023/8/23 17:43
 *
 * @author 唐富强
 */
@Data
public class BcmFscPayInfoBackAbilityReqBO implements Serializable {


    private static final long serialVersionUID = -6484036469451675505L;
    /**
     * 付款方名称
     */
    private String payerName;

    /**
     * 收款方id
     */
    private Long payeeId;

    /**
     * 交易时间
     */
    private Date busiTime;

    /**
     * 交易金额
     */
    private BigDecimal busiAmount;


    /**
     * 单据编号
     */
    private String busiOrderNo;

    /**
     * 单据id
     */
    private Long busiOrderId;

    /**
     * 明细ID
     */
    private Long shouldPayId;

    /**
     * 付款结果 1成功 0失败
     */
    private String payResult;
}
