/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import com.tydic.bcm.personal.commodity.api.BcmAddApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmAddApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmAddApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmAddApplyCommodityOrderService"})
public class BcmAddApplyCommodityOrderServiceImpl
implements BcmAddApplyCommodityOrderService {
    private final BcmApplyCommodityOrderMapper commodityOrderMapper;
    private final BcmApplyCommodityOrderItemMapper commodityOrderItemMapper;
    private final BcmFileMapper fileMapper;

    @PostMapping(value={"addApplyCommodityOrder"})
    public BcmAddApplyCommodityOrderRspBO addApplyCommodityOrder(@RequestBody BcmAddApplyCommodityOrderReqBO commodityOrderReqBO) {
        ParamValidateUtils.validate(commodityOrderReqBO);
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = BcmCommonBeanUtil.copyProperties(commodityOrderReqBO, BcmApplyCommodityOrderPO.class);
        Long applyOrderId = IdUtil.nextId();
        bcmApplyCommodityOrder.setId(IdUtil.nextId());
        bcmApplyCommodityOrder.setApplyOrderId(applyOrderId);
        String applyOrderCode = "SJSQ" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + String.format("%03d", RandomUtil.randomLong((long)4L));
        bcmApplyCommodityOrder.setApplyOrderCode(applyOrderCode);
        bcmApplyCommodityOrder.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmApplyCommodityOrder.setCreateTime(new Date());
        bcmApplyCommodityOrder.setCreateUserId(commodityOrderReqBO.getUserId());
        bcmApplyCommodityOrder.setCreateUserName(commodityOrderReqBO.getName());
        this.commodityOrderMapper.insert(bcmApplyCommodityOrder);
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem = BcmCommonBeanUtil.copyProperties(commodityOrderReqBO.getApplyCommodityOrderItem(), BcmApplyCommodityOrderItemPO.class);
        bcmApplyCommodityOrderItem.setId(IdUtil.nextId());
        Long applyOrderItemId = IdUtil.nextId();
        bcmApplyCommodityOrderItem.setApplyOrderItemId(applyOrderItemId);
        bcmApplyCommodityOrderItem.setApplyOrderId(applyOrderId);
        bcmApplyCommodityOrderItem.setCreateUserId(commodityOrderReqBO.getUserId());
        bcmApplyCommodityOrderItem.setCreateUserName(commodityOrderReqBO.getName());
        bcmApplyCommodityOrderItem.setCreateTime(new Date());
        bcmApplyCommodityOrderItem.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        this.commodityOrderItemMapper.insert(bcmApplyCommodityOrderItem);
        if (CollectionUtil.isNotEmpty((Collection)commodityOrderReqBO.getApplyCommodityOrderItem().getFileList())) {
            List<BcmFilePO> bcmFileList = BcmCommonBeanUtil.listCopyProperties(commodityOrderReqBO.getApplyCommodityOrderItem().getFileList(), BcmFilePO.class);
            bcmFileList.forEach(bcmFile -> {
                bcmFile.setId(IdUtil.nextId());
                bcmFile.setFileId(IdUtil.nextId() + "");
                bcmFile.setBusinessId(applyOrderItemId);
                bcmFile.setBusinessType(BcmPersonalCommonConstant.BusinessType.APPLY_ORDER_ITEM);
                bcmFile.setCreateTime(new Date());
                bcmFile.setCreateUserId(commodityOrderReqBO.getUserId());
                bcmFile.setCreateUserName(commodityOrderReqBO.getName());
                bcmFile.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            });
            this.fileMapper.insertBatch(bcmFileList);
        }
        BcmAddApplyCommodityOrderRspBO success = PerSonalRuUtil.success(BcmAddApplyCommodityOrderRspBO.class);
        success.setApplyOrderId(applyOrderId);
        return success;
    }

    public BcmAddApplyCommodityOrderServiceImpl(BcmApplyCommodityOrderMapper commodityOrderMapper, BcmApplyCommodityOrderItemMapper commodityOrderItemMapper, BcmFileMapper fileMapper) {
        this.commodityOrderMapper = commodityOrderMapper;
        this.commodityOrderItemMapper = commodityOrderItemMapper;
        this.fileMapper = fileMapper;
    }
}

