/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmApplyOrderItemBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailRspBO;
import com.tydic.bcm.personal.common.bo.BcmFileBO;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService"})
public class BcmQueryApplyOrderDetailServiceImpl
implements BcmQueryApplyOrderDetailService {
    private final BcmApplyCommodityOrderMapper applyCommodityOrderMapper;
    private final BcmApplyCommodityOrderItemMapper applyCommodityOrderItemMapper;
    private final BcmFileMapper fileMapper;

    @PostMapping(value={"queryApplyOrderDetail"})
    public BcmQueryApplyOrderDetailRspBO queryApplyOrderDetail(@RequestBody BcmQueryApplyOrderDetailReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = this.applyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrder == null) {
            throw new ZTBusinessException(String.format("%d\u4e0d\u5b58\u5728", reqBO.getApplyOrderId()));
        }
        BcmApplyOrderBO bcmApplyOrder = (BcmApplyOrderBO)BeanUtil.copyProperties((Object)bcmApplyCommodityOrder, BcmApplyOrderBO.class);
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem = this.applyCommodityOrderItemMapper.queryByApplyOrderId(reqBO.getApplyOrderId());
        BcmApplyOrderItemBO bcmApplyOrderItemBO = (BcmApplyOrderItemBO)BeanUtil.copyProperties((Object)bcmApplyCommodityOrderItem, BcmApplyOrderItemBO.class);
        BcmFilePO bcmFile = new BcmFilePO();
        bcmFile.setBusinessId(bcmApplyCommodityOrderItem.getApplyOrderItemId());
        List<BcmFilePO> bcmFileList = this.fileMapper.getList(bcmFile);
        if (CollectionUtils.isNotEmpty(bcmFileList)) {
            bcmApplyOrderItemBO.setFileList(BcmCommonBeanUtil.listCopyProperties(bcmFileList, BcmFileBO.class));
        }
        bcmApplyOrder.setApplyOrderItem(bcmApplyOrderItemBO);
        BcmQueryApplyOrderDetailRspBO resp = new BcmQueryApplyOrderDetailRspBO();
        resp.setApplyOrder(bcmApplyOrder);
        resp.setRespCode("0000");
        resp.setRespDesc("\u6210\u529f");
        return resp;
    }

    public BcmQueryApplyOrderDetailServiceImpl(BcmApplyCommodityOrderMapper applyCommodityOrderMapper, BcmApplyCommodityOrderItemMapper applyCommodityOrderItemMapper, BcmFileMapper fileMapper) {
        this.applyCommodityOrderMapper = applyCommodityOrderMapper;
        this.applyCommodityOrderItemMapper = applyCommodityOrderItemMapper;
        this.fileMapper = fileMapper;
    }
}

