/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmUpdateApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatus;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmUpdateApplyCommodityOrderService"})
public class BcmUpdateApplyCommodityOrderServiceImpl
implements BcmUpdateApplyCommodityOrderService {
    private final BcmApplyCommodityOrderMapper applyCommodityOrderMapper;
    private final BcmApplyCommodityOrderItemMapper applyCommodityOrderItemMapper;
    private final BcmFileMapper fileMapper;

    @PostMapping(value={"updateApplyCommodityOrder"})
    public BcmUpdateApplyCommodityOrderRspBO updateApplyCommodityOrder(@RequestBody BcmUpdateApplyCommodityOrderReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = this.applyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (!BcmPersonalApplyOrderStatus.DRAFT.getStatus().equals(bcmApplyCommodityOrder.getApplyOrderStatus())) {
            throw new ZTBusinessException("\u8be5\u7533\u8bf7\u5355\u4e0d\u5904\u4e8e\u8349\u7a3f\u72b6\u6001,\u4e0d\u80fd\u4fee\u6539");
        }
        BcmApplyCommodityOrderPO updateOrder = (BcmApplyCommodityOrderPO)BeanUtil.copyProperties((Object)reqBO, BcmApplyCommodityOrderPO.class);
        updateOrder.setId(bcmApplyCommodityOrder.getId());
        updateOrder.setUpdateUserId(reqBO.getUpdateUserId());
        updateOrder.setUpdateUserName(reqBO.getUpdateUserName());
        updateOrder.setUpdateTime(new Date());
        this.applyCommodityOrderMapper.update(updateOrder);
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem = (BcmApplyCommodityOrderItemPO)BeanUtil.copyProperties((Object)reqBO.getApplyOrderItem(), BcmApplyCommodityOrderItemPO.class);
        bcmApplyCommodityOrderItem.setUpdateUserId(reqBO.getUpdateUserId());
        bcmApplyCommodityOrderItem.setUpdateUserName(reqBO.getUpdateUserName());
        bcmApplyCommodityOrderItem.setUpdateTime(new Date());
        this.applyCommodityOrderItemMapper.updateByOrderItemId(bcmApplyCommodityOrderItem);
        this.fileMapper.deleteByBusinessId(bcmApplyCommodityOrderItem.getApplyOrderItemId());
        if (CollectionUtil.isNotEmpty((Collection)reqBO.getApplyOrderItem().getFileList())) {
            List<BcmFilePO> bcmFileList = BcmCommonBeanUtil.listCopyProperties(reqBO.getApplyOrderItem().getFileList(), BcmFilePO.class);
            bcmFileList.forEach(bcmFile -> {
                bcmFile.setId(IdUtil.nextId());
                bcmFile.setFileId(IdUtil.nextId() + "");
                bcmFile.setBusinessId(bcmApplyCommodityOrderItem.getApplyOrderItemId());
                bcmFile.setBusinessType(BcmPersonalCommonConstant.BusinessType.APPLY_ORDER_ITEM);
                bcmFile.setCreateTime(new Date());
                bcmFile.setCreateUserId(reqBO.getUpdateUserId());
                bcmFile.setCreateUserName(reqBO.getUpdateUserName());
                bcmFile.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            });
            this.fileMapper.insertBatch(bcmFileList);
        }
        return PerSonalRuUtil.success(BcmUpdateApplyCommodityOrderRspBO.class);
    }

    public BcmUpdateApplyCommodityOrderServiceImpl(BcmApplyCommodityOrderMapper applyCommodityOrderMapper, BcmApplyCommodityOrderItemMapper applyCommodityOrderItemMapper, BcmFileMapper fileMapper) {
        this.applyCommodityOrderMapper = applyCommodityOrderMapper;
        this.applyCommodityOrderItemMapper = applyCommodityOrderItemMapper;
        this.fileMapper = fileMapper;
    }
}

