/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmAddSuggestedManagementInfoService;
import com.tydic.bcm.personal.common.bo.BcmAddSuggestedManagementInfoReqBO;
import com.tydic.bcm.personal.common.bo.BcmAddSuggestedManagementInfoRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.dao.BcmSuggestedManagementInfoMapper;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.po.BcmSuggestedManagementInfoPO;
import com.tydic.bcm.personal.utils.IdUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmAddSuggestedManagementInfoService"})
public class BcmAddSuggestedManagementInfoServiceImpl
implements BcmAddSuggestedManagementInfoService {
    @Autowired
    private BcmSuggestedManagementInfoMapper bcmSuggestedManagementInfoMapper;
    @Autowired
    private BcmFileMapper bcmFileMapper;

    @PostMapping(value={"addSuggestedManagementInfo"})
    public BcmAddSuggestedManagementInfoRspBO addSuggestedManagementInfo(@RequestBody BcmAddSuggestedManagementInfoReqBO reqBO) {
        BcmAddSuggestedManagementInfoRspBO rspBO = new BcmAddSuggestedManagementInfoRspBO();
        this.verifyParam(reqBO);
        BcmSuggestedManagementInfoPO insertPO = this.setReqBO(reqBO);
        int i = this.bcmSuggestedManagementInfoMapper.insert(insertPO);
        if (i < 1) {
            throw new ZTBusinessException("\u65b0\u589e\u6211\u7684\u5efa\u8bae\u5931\u8d25");
        }
        this.insertFile(reqBO, insertPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void insertFile(BcmAddSuggestedManagementInfoReqBO reqBO, BcmSuggestedManagementInfoPO insertPO) {
        List<BcmFilePO> insertPOList;
        int m;
        if (ObjectUtil.isNotEmpty((Object)reqBO.getFileBOList()) && (m = this.bcmFileMapper.insertBatch(insertPOList = reqBO.getFileBOList().stream().map(item -> {
            BcmFilePO bcmFilePO = (BcmFilePO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)item), BcmFilePO.class);
            bcmFilePO.setId(IdUtil.nextId());
            bcmFilePO.setFileId(IdUtil.nextId().toString());
            bcmFilePO.setBusinessId(insertPO.getSuggestedId());
            bcmFilePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.SUGGESTION);
            bcmFilePO.setCreateTime(new Date());
            bcmFilePO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            return bcmFilePO;
        }).collect(Collectors.toList()))) < 1) {
            throw new ZTBusinessException("\u6211\u7684\u5efa\u8bae\u65b0\u589e\u9644\u4ef6\u5931\u8d25");
        }
    }

    private BcmSuggestedManagementInfoPO setReqBO(BcmAddSuggestedManagementInfoReqBO reqBO) {
        BcmSuggestedManagementInfoPO inertPO = (BcmSuggestedManagementInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), BcmSuggestedManagementInfoPO.class);
        inertPO.setId(IdUtil.nextId());
        inertPO.setSuggestedId(IdUtil.nextId());
        inertPO.setSuggestedNo("a");
        inertPO.setSuggestedTime(new Date());
        inertPO.setSuggestedNo(BcmAddSuggestedManagementInfoServiceImpl.createSuggestedNo());
        inertPO.setDealStatus(BcmPersonalCommonConstant.SuggestedDealStatus.UNTREATED);
        inertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        return inertPO;
    }

    private void verifyParam(BcmAddSuggestedManagementInfoReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u65b0\u589e\u6211\u7684\u5efa\u8bae\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSuggestedColumn())) {
            throw new ZTBusinessException("\u65b0\u589e\u6211\u7684\u5efa\u8bae\u5165\u53c2\u5efa\u8bae\u680f\u76ee\u3010suggestedColumn\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSuggestedTitle())) {
            throw new ZTBusinessException("\u65b0\u589e\u6211\u7684\u5efa\u8bae\u5165\u53c2\u5efa\u8bae\u6807\u9898\u3010suggestedTitle\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSuggestedContent())) {
            throw new ZTBusinessException("\u65b0\u589e\u6211\u7684\u5efa\u8bae\u5165\u53c2\u5efa\u8bae\u5185\u5bb9\u3010suggestedContent\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getIsAnonymous())) {
            throw new ZTBusinessException("\u65b0\u589e\u6211\u7684\u5efa\u8bae\u5165\u53c2\u662f\u5426\u533f\u540d\u3010isAnonymous\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSuggestedUserId())) {
            throw new ZTBusinessException("\u65b0\u589e\u6211\u7684\u5efa\u8bae\u5165\u53c2\u5efa\u8bae\u4ebaID\u3010suggestedUserId\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSuggestedUserName())) {
            throw new ZTBusinessException("\u65b0\u589e\u6211\u7684\u5efa\u8bae\u5165\u53c2\u5efa\u8bae\u4eba\u540d\u79f0\u3010suggestedUserName\u3011\u4e3a\u7a7a");
        }
    }

    public static String createSuggestedNo() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timestamp = sdf.format(now);
        Random random = new Random();
        int randomNumber = random.nextInt(9000) + 1000;
        String code = "JYD" + timestamp + randomNumber;
        return code;
    }
}

