/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmIncrementSyncCostService;
import com.tydic.bcm.personal.common.bo.BcmCostInfoBO;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncCostReqBO;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncCostRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmCostInfoMapper;
import com.tydic.bcm.personal.po.BcmCostInfoPO;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BcmIncrementSyncCostServiceImpl
implements BcmIncrementSyncCostService {
    @Autowired
    private BcmCostInfoMapper bcmCostInfoMapper;

    public BcmIncrementSyncCostRspBO incrementSyncCost(BcmIncrementSyncCostReqBO reqBO) {
        this.verifyParam(reqBO);
        this.incSyncCost(reqBO);
        return PerSonalRuUtil.success(BcmIncrementSyncCostRspBO.class);
    }

    private void incSyncCost(BcmIncrementSyncCostReqBO reqBO) {
        ArrayList<BcmCostInfoPO> addList = new ArrayList<BcmCostInfoPO>();
        ArrayList<BcmCostInfoPO> updateList = new ArrayList<BcmCostInfoPO>();
        Date now = new Date();
        for (BcmCostInfoBO bo : reqBO.getChangeList()) {
            BcmCostInfoPO po = new BcmCostInfoPO();
            if (BcmPersonalCommonConstant.OperType.ADD.equals(bo.getOperType())) {
                po = (BcmCostInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), BcmCostInfoPO.class);
                po.setId(IdUtil.nextId());
                po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                if (po.getCreateTime() == null) {
                    po.setCreateTime(now);
                }
                if (po.getUpdateTime() == null) {
                    po.setUpdateTime(now);
                }
                addList.add(po);
                continue;
            }
            if (BcmPersonalCommonConstant.OperType.UPDATE.equals(bo.getOperType())) {
                po = (BcmCostInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), BcmCostInfoPO.class);
                if (po.getUpdateTime() == null) {
                    po.setUpdateTime(now);
                }
                updateList.add(po);
                continue;
            }
            po.setCostCenterCode(bo.getCostCenterCode());
            po.setDelFlag(BcmPersonalCommonConstant.DelFlag.YES);
            updateList.add(po);
        }
        if (CollectionUtils.isEmpty(addList)) {
            this.bcmCostInfoMapper.insertBatch(addList);
        }
        if (CollectionUtils.isEmpty(updateList)) {
            this.bcmCostInfoMapper.updateBatch(updateList);
        }
    }

    private void verifyParam(BcmIncrementSyncCostReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getChangeList())) {
            throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4fe1\u606flist\u4e0d\u80fd\u4e3anull");
        }
        for (BcmCostInfoBO bo : reqBO.getChangeList()) {
            if (StringUtils.isEmpty((Object)bo.getCostCenterCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getCostCenterName())) {
                throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4e2d\u5fc3\u540d\u79f0\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgName())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getStatus() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u72b6\u6001\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getOperType() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u6807\u8bc6\u4e0d\u80fd\u4e3anull");
            }
            if (BcmPersonalCommonConstant.OperType.ADD.equals(bo.getOperType()) || BcmPersonalCommonConstant.OperType.UPDATE.equals(bo.getOperType()) || BcmPersonalCommonConstant.OperType.DEL.equals(bo.getOperType())) continue;
            throw new ZTBusinessException("\u5165\u53c2\u6807\u8bc6\u9519\u8bef");
        }
    }
}

