/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryBudgetProjectPageListService;
import com.tydic.bcm.personal.common.bo.BcmBudgetProjectInfoBO;
import com.tydic.bcm.personal.common.bo.BcmQueryBudgetProjectPageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryBudgetProjectPageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBudgetProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBudgetProjectInfoPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmQueryBudgetProjectPageListService"})
public class BcmQueryBudgetProjectPageListServiceImpl
implements BcmQueryBudgetProjectPageListService {
    @Autowired
    private BcmBudgetProjectInfoMapper bcmBudgetProjectInfoMapper;

    @PostMapping(value={"queryBudgetProjectPageList"})
    public BcmQueryBudgetProjectPageListRspBO queryBudgetProjectPageList(@RequestBody BcmQueryBudgetProjectPageListReqBO reqBO) {
        this.verifyParam(reqBO);
        BcmBudgetProjectInfoPO bcmBudgetProjectInfoPO = this.getBcmBudgetProjectInfoPO(reqBO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmBudgetProjectInfoPO> list = this.bcmBudgetProjectInfoMapper.getListPage(bcmBudgetProjectInfoPO, (Page<BcmBudgetProjectInfoPO>)page);
        return this.setRspBO(list, (Page<BcmBudgetProjectInfoPO>)page);
    }

    private BcmQueryBudgetProjectPageListRspBO setRspBO(List<BcmBudgetProjectInfoPO> list, Page<BcmBudgetProjectInfoPO> page) {
        BcmQueryBudgetProjectPageListRspBO rspBO = PerSonalRuUtil.success(BcmQueryBudgetProjectPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(PerSonalRuUtil.jsl(list, BcmBudgetProjectInfoBO.class));
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (BcmBudgetProjectInfoBO bo : rspBO.getRows()) {
                if (BcmPersonalCommonConstant.Status.DISABLE.equals(bo.getStatus())) {
                    bo.setStatusStr("\u505c\u7528");
                    continue;
                }
                if (!BcmPersonalCommonConstant.Status.ENABLE.equals(bo.getStatus())) continue;
                bo.setStatusStr("\u542f\u7528");
            }
        }
        return rspBO;
    }

    private BcmBudgetProjectInfoPO getBcmBudgetProjectInfoPO(BcmQueryBudgetProjectPageListReqBO reqBO) {
        BcmBudgetProjectInfoPO bcmBudgetProjectInfoPO = (BcmBudgetProjectInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), BcmBudgetProjectInfoPO.class);
        bcmBudgetProjectInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmBudgetProjectInfoPO.setOrderBy("UPDATE_TIME DESC");
        return bcmBudgetProjectInfoPO;
    }

    private void verifyParam(BcmQueryBudgetProjectPageListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
    }
}

