/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryCostPageListService;
import com.tydic.bcm.personal.common.bo.BcmCostInfoBO;
import com.tydic.bcm.personal.common.bo.BcmQueryCostPageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryCostPageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmCostInfoMapper;
import com.tydic.bcm.personal.po.BcmCostInfoPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmQueryCostPageListService"})
public class BcmQueryCostPageListServiceImpl
implements BcmQueryCostPageListService {
    @Autowired
    private BcmCostInfoMapper bcmCostInfoMapper;

    @PostMapping(value={"queryCostPageList"})
    public BcmQueryCostPageListRspBO queryCostPageList(@RequestBody BcmQueryCostPageListReqBO reqBO) {
        this.verifyParam(reqBO);
        BcmCostInfoPO bcmCostInfoPO = this.getBcmCostInfoPO(reqBO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmCostInfoPO> list = this.bcmCostInfoMapper.getListPage(bcmCostInfoPO, (Page<BcmCostInfoPO>)page);
        return this.setRspBO(list, (Page<BcmCostInfoPO>)page);
    }

    private BcmQueryCostPageListRspBO setRspBO(List<BcmCostInfoPO> list, Page<BcmCostInfoPO> page) {
        BcmQueryCostPageListRspBO rspBO = PerSonalRuUtil.success(BcmQueryCostPageListRspBO.class);
        rspBO.setRows(PerSonalRuUtil.jsl(list, BcmCostInfoBO.class));
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (BcmCostInfoBO bo : rspBO.getRows()) {
                if (BcmPersonalCommonConstant.Status.DISABLE.equals(bo.getStatus())) {
                    bo.setStatusStr("\u505c\u7528");
                    continue;
                }
                if (!BcmPersonalCommonConstant.Status.ENABLE.equals(bo.getStatus())) continue;
                bo.setStatusStr("\u542f\u7528");
            }
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private BcmCostInfoPO getBcmCostInfoPO(BcmQueryCostPageListReqBO reqBO) {
        BcmCostInfoPO bcmCostInfoPO = (BcmCostInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), BcmCostInfoPO.class);
        bcmCostInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmCostInfoPO.setOrderBy("UPDATE_TIME DESC");
        return bcmCostInfoPO;
    }

    private void verifyParam(BcmQueryCostPageListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
    }
}

