/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.settle.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalSettleConstant;
import com.tydic.bcm.personal.dao.BcmBondDeductInfoMapper;
import com.tydic.bcm.personal.po.BcmBondDeductInfoPO;
import com.tydic.bcm.personal.settle.api.BcmQueryBondDeductPageListService;
import com.tydic.bcm.personal.settle.bo.BcmBondDeductInfoBO;
import com.tydic.bcm.personal.settle.bo.BcmQueryBondDeductPageListReqBO;
import com.tydic.bcm.personal.settle.bo.BcmQueryBondDeductPageListRspBO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.settle.api.BcmQueryBondDeductPageListService"})
public class BcmQueryBondDeductPageListServiceImpl
implements BcmQueryBondDeductPageListService {
    @Autowired
    private BcmBondDeductInfoMapper bcmBondDeductInfoMapper;

    @PostMapping(value={"queryBondDeductPageList"})
    public BcmQueryBondDeductPageListRspBO queryBondDeductPageList(@RequestBody BcmQueryBondDeductPageListReqBO reqBO) {
        this.verifyParam(reqBO);
        BcmBondDeductInfoPO bcmBondDeductInfoPO = this.getBcmBondDeductInfoPO(reqBO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmBondDeductInfoPO> list = this.bcmBondDeductInfoMapper.getListPage(bcmBondDeductInfoPO, (Page<BcmBondDeductInfoPO>)page);
        return this.setRspBO(list, (Page<BcmBondDeductInfoPO>)page);
    }

    private BcmQueryBondDeductPageListRspBO setRspBO(List<BcmBondDeductInfoPO> list, Page<BcmBondDeductInfoPO> page) {
        BcmQueryBondDeductPageListRspBO rspBO = PerSonalRuUtil.success(BcmQueryBondDeductPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(PerSonalRuUtil.jsl(list, BcmBondDeductInfoBO.class));
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (BcmBondDeductInfoBO bo : rspBO.getRows()) {
                if (BcmPersonalSettleConstant.BondDeductStatus.CONFIRMING.equals(bo.getDocStatus())) {
                    bo.setDocStatusStr("\u786e\u8ba4\u4e2d");
                    continue;
                }
                if (BcmPersonalSettleConstant.BondDeductStatus.DECLINED.equals(bo.getDocStatus())) {
                    bo.setDocStatusStr("\u5df2\u62d2\u7edd");
                    continue;
                }
                if (!BcmPersonalSettleConstant.BondDeductStatus.CONFIRMED.equals(bo.getDocStatus())) continue;
                bo.setDocStatusStr("\u5df2\u786e\u8ba4");
            }
        }
        return rspBO;
    }

    private BcmBondDeductInfoPO getBcmBondDeductInfoPO(BcmQueryBondDeductPageListReqBO reqBO) {
        BcmBondDeductInfoPO bcmBondDeductInfoPO = (BcmBondDeductInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), BcmBondDeductInfoPO.class);
        bcmBondDeductInfoPO.setDelFlag(BcmPersonalSettleConstant.DelFlag.NO);
        bcmBondDeductInfoPO.setOrderBy("CREATE_TIME DESC");
        return bcmBondDeductInfoPO;
    }

    private void verifyParam(BcmQueryBondDeductPageListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
    }
}

