package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmDeleteApplyCompanyConfService;
import com.tydic.bcm.personal.commodity.bo.BcmDeleteApplyCompanyConfReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmDeleteApplyCompanyConfRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyOrderSelTimeLimitConfMapper;
import com.tydic.bcm.personal.po.BcmApplyOrderSelTimeLimitConfPO;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 标题 BcmDeleteApplyCompanyConfServiceImpl
 * 说明 上架申请单-删除配置列表实现
 * 时间 2023/7/28 11:00
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmDeleteApplyCompanyConfServiceImpl implements BcmDeleteApplyCompanyConfService {

    @Autowired
    private BcmApplyOrderSelTimeLimitConfMapper bcmApplyOrderSelTimeLimitConfMapper;

    /**
     * 删除配置列表实现
     * @param reqBO
     * @return
     */
    @Override
    public BcmDeleteApplyCompanyConfRspBO deleteApplyCompanyConf(BcmDeleteApplyCompanyConfReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmApplyOrderSelTimeLimitConfPO bcmApplyOrderSelTimeLimitConfPO = getBcmApplyOrderSelTimeLimitConfPO(reqBO);
        bcmApplyOrderSelTimeLimitConfMapper.updateById(bcmApplyOrderSelTimeLimitConfPO);
        return PerSonalRuUtil.success(BcmDeleteApplyCompanyConfRspBO.class);
    }

    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmApplyOrderSelTimeLimitConfPO getBcmApplyOrderSelTimeLimitConfPO(BcmDeleteApplyCompanyConfReqBO reqBO){
        BcmApplyOrderSelTimeLimitConfPO bcmApplyOrderSelTimeLimitConfPO = PerSonalRuUtil.js(reqBO, BcmApplyOrderSelTimeLimitConfPO.class);
        bcmApplyOrderSelTimeLimitConfPO.setUpdateTime(new Date());
        bcmApplyOrderSelTimeLimitConfPO.setUpdateUserId(reqBO.getUserId());
        bcmApplyOrderSelTimeLimitConfPO.setUpdateUserName(reqBO.getUserName());
        bcmApplyOrderSelTimeLimitConfPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        return bcmApplyOrderSelTimeLimitConfPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmDeleteApplyCompanyConfReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getId() == null){
            throw new ZTBusinessException("参数id不能为null");
        }
    }
}
