package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmApplyOrderItemBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailRspBO;
import com.tydic.bcm.personal.common.bo.BcmFileBO;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/7/28 14:55
 */
@HTServiceImpl
@RequiredArgsConstructor
public class BcmQueryApplyOrderDetailServiceImpl implements BcmQueryApplyOrderDetailService {

    private final BcmApplyCommodityOrderMapper applyCommodityOrderMapper;

    private final BcmApplyCommodityOrderItemMapper applyCommodityOrderItemMapper;

    private final BcmFileMapper fileMapper;


    @Override
    public BcmQueryApplyOrderDetailRspBO queryApplyOrderDetail(BcmQueryApplyOrderDetailReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);

        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = applyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrder == null) {
            throw new ZTBusinessException(String.format("%d不存在", reqBO.getApplyOrderId()));
        }

        BcmApplyOrderBO bcmApplyOrder = BeanUtil.copyProperties(bcmApplyCommodityOrder, BcmApplyOrderBO.class);
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem = applyCommodityOrderItemMapper.queryByApplyOrderId(reqBO.getApplyOrderId());
        BcmApplyOrderItemBO bcmApplyOrderItemBO = BeanUtil.copyProperties(bcmApplyCommodityOrderItem, BcmApplyOrderItemBO.class);

        BcmFilePO bcmFile = new BcmFilePO();
        bcmFile.setBusinessId(bcmApplyCommodityOrderItem.getApplyOrderItemId());
        List<BcmFilePO> bcmFileList = fileMapper.getList(bcmFile);
        if (CollectionUtils.isNotEmpty(bcmFileList)) {
            bcmApplyOrderItemBO.setFileList(BcmCommonBeanUtil.listCopyProperties(bcmFileList, BcmFileBO.class));
        }
        bcmApplyOrder.setApplyOrderItem(bcmApplyOrderItemBO);

        //TODO: 未添加响应明细

        BcmQueryApplyOrderDetailRspBO resp = new BcmQueryApplyOrderDetailRspBO();
        resp.setApplyOrder(bcmApplyOrder);
        resp.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        resp.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return resp;
    }
}
