package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmBatchUpdateBudgetModeConfigService;
import com.tydic.bcm.personal.common.bo.BcmBatchUpdateBudgetModeConfigReqBO;
import com.tydic.bcm.personal.common.bo.BcmBatchUpdateBudgetModeConfigRspBO;
import com.tydic.bcm.personal.dao.BcmBudgetModeConfigMapper;
import com.tydic.bcm.personal.po.BcmBudgetModeConfigPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 类名： BcmBatchUpdateBudgetModeConfigServiceImpl
 * 说明：预算模式设置-预算模式修改（批量）实现
 *
 * @author： lishiqing
 * 时间： 2023/7/24 10:13
 */
@HTServiceImpl
public class BcmBatchUpdateBudgetModeConfigServiceImpl implements BcmBatchUpdateBudgetModeConfigService {

    @Autowired
    private BcmBudgetModeConfigMapper bcmBudgetModeConfigMapper;

    @Override
    public BcmBatchUpdateBudgetModeConfigRspBO batchUpdateBudgetModeConfig(BcmBatchUpdateBudgetModeConfigReqBO reqBO) {
        BcmBatchUpdateBudgetModeConfigRspBO rspBO = new BcmBatchUpdateBudgetModeConfigRspBO();

        // 参数校验
        verifyParam(reqBO);

        // 入参组装
        BcmBudgetModeConfigPO batchUpdatePO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmBudgetModeConfigPO.class);
        batchUpdatePO.setUpdateTime(new Date());

        // 根据ID集合批量修改数据
        int i = bcmBudgetModeConfigMapper.updateById(batchUpdatePO);
        if (i < 1) {
            throw new ZTBusinessException("预算模式修改（批量）失败");
        }

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmBatchUpdateBudgetModeConfigReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("预算模式修改（批量）入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getIds())) {
            throw new ZTBusinessException("预算模式修改（批量）修改主键集合【ids】入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getBudgetMode())) {
            throw new ZTBusinessException("预算模式修改（批量）预算模式【budgetMode】入参为空");
        }
    }
}
