package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmIncrementSyncCostService;
import com.tydic.bcm.personal.common.bo.BcmCostInfoBO;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncCostReqBO;
import com.tydic.bcm.personal.common.bo.BcmIncrementSyncCostRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmCostInfoMapper;
import com.tydic.bcm.personal.po.BcmCostInfoPO;
import com.tydic.bcm.personal.utils.IdUtil;
import com.tydic.bcm.personal.utils.PerSonalRuUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题 BcmIncrementSyncCostServiceImpl
 * 说明 成本中心查询-成本中心增量同步实现
 * 时间 2023/7/20 16:08
 *
 * @author 唐富强
 */
public class BcmIncrementSyncCostServiceImpl implements BcmIncrementSyncCostService {

    @Autowired
    private BcmCostInfoMapper bcmCostInfoMapper;


    /**
     * 成本中心增量同步
     * @param reqBO
     * @return
     */
    @Override
    public BcmIncrementSyncCostRspBO incrementSyncCost(BcmIncrementSyncCostReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //增量同步
        incSyncCost(reqBO);
        return PerSonalRuUtil.success(BcmIncrementSyncCostRspBO.class);
    }

    /**
     * 增量同步
     * @param reqBO
     */
    private void incSyncCost(BcmIncrementSyncCostReqBO reqBO){
        List<BcmCostInfoPO> addList = new ArrayList<>();
        List<BcmCostInfoPO> updateList = new ArrayList<>();
        Date now = new Date();
       for (BcmCostInfoBO bo:reqBO.getChangeList()) {
           BcmCostInfoPO po = new BcmCostInfoPO();
           //新增
           if(BcmPersonalCommonConstant.OperType.ADD.equals(bo.getOperType())){
               po = JSONObject.parseObject(JSONObject.toJSONString(bo),BcmCostInfoPO.class);
               po.setId(IdUtil.nextId());
               po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
               if(po.getCreateTime() == null){
                   po.setCreateTime(now);
               }
               if(po.getUpdateTime() == null){
                   po.setUpdateTime(now);
               }
               addList.add(po);
           } else if (BcmPersonalCommonConstant.OperType.UPDATE.equals(bo.getOperType())) {
               //修改
               po = JSONObject.parseObject(JSONObject.toJSONString(bo),BcmCostInfoPO.class);
               if(po.getUpdateTime() == null){
                   po.setUpdateTime(now);
               }
               updateList.add(po);
           } else {
               //删除
               po.setCostCenterCode(bo.getCostCenterCode());
               po.setDelFlag(BcmPersonalCommonConstant.DelFlag.YES);
               updateList.add(po);
           }
       }
       if(CollectionUtils.isEmpty(addList)){
           bcmCostInfoMapper.insertBatch(addList);
       }
       if(CollectionUtils.isEmpty(updateList)){
           bcmCostInfoMapper.updateBatch(updateList);
       }
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmIncrementSyncCostReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(CollectionUtils.isEmpty(reqBO.getChangeList())){
            throw new ZTBusinessException("入参成本信息list不能为null");
        }
        for (BcmCostInfoBO bo:reqBO.getChangeList()) {
            if(StringUtils.isEmpty(bo.getCostCenterCode())){
                throw new ZTBusinessException("入参成本中心编码不能为null");
            }
            if(StringUtils.isEmpty(bo.getCostCenterName())){
                throw new ZTBusinessException("入参成本中心名称不能为null");
            }
            if (StringUtils.isEmpty(bo.getFinancialOrgCode())){
                throw new ZTBusinessException("入参财务机构编号不能为null");
            }
            if(StringUtils.isEmpty(bo.getFinancialOrgName())){
                throw new ZTBusinessException("入参财务中心编码不能为null");

            }
            if(bo.getStatus() == null){
                throw new ZTBusinessException("入参状态不能为null");
            }
            if(bo.getOperType() == null){
                throw new ZTBusinessException("入参标识不能为null");
            }
            if(!BcmPersonalCommonConstant.OperType.ADD.equals(bo.getOperType())
            && !BcmPersonalCommonConstant.OperType.UPDATE.equals(bo.getOperType())
            && !BcmPersonalCommonConstant.OperType.DEL.equals(bo.getOperType())){
                throw new ZTBusinessException("入参标识错误");
            }
        }
    }
}
