package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryPurchasePurposeConfigPageListService;
import com.tydic.bcm.personal.common.bo.BcmPurchasePurposeConfigBO;
import com.tydic.bcm.personal.common.bo.BcmQueryPurchasePurposeConfigPageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryPurchasePurposeConfigPageListRspBO;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeConfigMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeConfigPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： BcmQueryPurchasePurposeConfigPageListServiceImpl
 * 说明：采购用途设置-采购用途列表查询(分页)实现
 *
 * @author： lishiqing
 * 时间： 2023/7/21 10:28
 */
@HTServiceImpl
public class BcmQueryPurchasePurposeConfigPageListServiceImpl implements BcmQueryPurchasePurposeConfigPageListService {

    @Autowired
    private BcmPurchasePurposeConfigMapper bcmPurchasePurposeConfigMapper;

    /**
     * 采购用途列表查询(分页)方法
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryPurchasePurposeConfigPageListRspBO queryPurchasePurposeConfigPageList(BcmQueryPurchasePurposeConfigPageListReqBO reqBO) {
        BcmQueryPurchasePurposeConfigPageListRspBO rspBO = new BcmQueryPurchasePurposeConfigPageListRspBO();

        // 入参组装
        Page<BcmPurchasePurposeConfigPO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        BcmPurchasePurposeConfigPO purposeConfigPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmPurchasePurposeConfigPO.class);
        purposeConfigPO.setSortName("UPDATE_TIME");
        purposeConfigPO.setSortOrder("DESC");

        // 根据条件分页查询列表数据
        List<BcmPurchasePurposeConfigPO> bcmPurchasePurposeConfigPOList =  bcmPurchasePurposeConfigMapper.getPageList(purposeConfigPO,page);

        // 出参组装
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(bcmPurchasePurposeConfigPOList) ?
                JSONObject.parseArray(JSONObject.toJSONString(bcmPurchasePurposeConfigPOList), BcmPurchasePurposeConfigBO.class) : new ArrayList<>());

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
