package com.tydic.bcm.personal.constants;

import com.google.common.collect.ImmutableMap;

import java.util.Map;

/**
 * 描述: 〈交行公用模块个性化功能常量类〉
 * @author : yuhao
 * @date : 2023/7/19 15:49
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public class BcmPersonalCommonConstant {

    /**
     * 操作标识
     */
    public static final class OperType{
        /**
         * 新增
         */
        public static final Integer ADD = 1;

        /**
         * 修改
         */
        public static final Integer UPDATE = 2;

        /**
         * 删除
         */
        public static final Integer DEL = 3;
    }


    /**
     * 是否删除标识
     */
    public static final class DelFlag {
        /**
         * 生效
         */
        public static final Integer NO = 0;

        /**
         * 已删除
         */
        public static final Integer YES = 1;
    }

    /**
     * 是否标识
     */
    public static final class YesOrNo {
        /**
         * 是
         */
        public static final Integer YES = 0;

        /**
         * 否
         */
        public static final Integer NO = 1;

        /**
         * 是否标识Map
         */
        public static final Map<Integer,String> YesOrNoMap = ImmutableMap.of(0,"是",1,"否");

    }

    /**
     * 关联操作类型
     */
    public static final class RelOperType {
        /**
         * 关联
         */
        public static final Integer REL = 1;

        /**
         * 解除关联
         */
        public static final Integer NO_REL = 2;
    }

    /**
     * 关联状态
     */
    public static final class RelStatus {
        /**
         * 已关联
         */
        public static final Integer ASSOCIATED = 1;

        /**
         * 未关联
         */
       public static final Integer UNASSOCIATED = 2;

       /**
        * 收支项目失效
        */
        public static final Integer PAYMENT_PROJECT_EXP = 3;

        /**
         * 关联状态Map
         */
        public static final Map<Integer,String> RelStatusMap = ImmutableMap.of(1,"已关联",2,"未关联",3,"收支项目失效");
    }

    /**
     * 预算模式
     */
    public static final class BudgetMode {
        /**
         * 未设置
         */
        public static final Integer NOT_SET = 0;

        /**
         * 财务事项申请单
         */
        public static final Integer FINANCIAL_MATTERS_APPLICATION_FORM = 1;

        /**
         * 成本中心
         */
        public static final Integer COST_CENTER = 2;

        /**
         * 预算模式Map
         */
        public static final Map<Integer,String> BudgetModeMap = ImmutableMap.of(0,"未设置",1,"财务事项申请单",2,"成本中心");

    }
    /**
     * 通用状态
     */
    public static final class Status{

        /**
         * 启用
         */
        public static final Integer ENABLE = 1;

        /**
         * 启用翻译
         */
        public static final String ENABLE_STR = "启用";


        /**
         * 停用
         */
        public static final Integer DISABLE = 0;

        /**
         * 停用翻译
         */
        public static final String DISABLE_STR = "停用";


    }

    /**
     * 单据类型
     */
    public static final class BusinessType{


        /**
         * 1:上架申请单
         */
        public static final Integer APPLY_ORDER_ITEM = 1;

        /**
         * 2：供应商应答单
         */
        public static final Integer REPLY_ORDER_ITEM = 2;


        /**
         * 建议
         */
        public static final Integer SUGGESTION = 3;
    }

    /**
     * 是否匿名
     */
    public static class IsAnonymous{
        /**
         * 是
         */
        public static final Integer YES = 0;

        /**
         * 否
         */
        public static final Integer NO = 1;
    }

    /**
     * 建议单处理状态
     */
    public static final class SuggestedDealStatus {
        /**
         *  未处理
         */
        public static final Integer UNTREATED = 0;

        /**
         * 已处理
         */
        public static final Integer PROCESSED = 1;
    }


    /**
     * 建议栏目
     */
    public static final class  SuggestedColumn{

        /**
         * 业务交流
         */
        public static final Integer BUSINESS_EXCHANGE = 1;

        public static final String BUSINESS_EXCHANGE_STR = "业务交流";

        /**
         * 问题反馈
         */
        public static final Integer PROBLEM_FEEDBACK = 2;

        public static final String PROBLEM_FEEDBACK_STR = "问题反馈";

        /**
         * 系统优化建议
         */
        public static final Integer SYSTEM_SUGGESTION = 3;

        public static final String SYSTEM_SUGGESTION_STR = "系统优化建议";

        /**
         * 集中采购违规问题反馈
         */
        public static final Integer VIOLATION_FEEDBACK= 4;

        public static final String VIOLATION_FEEDBACK_STR= "集中采购违规问题反馈";


    }

    /**
     * 处理状态
     */
    public static final class DealStatus{

        /**
         * 未处理
         */
        public static final Integer UNTREATED = 0;

        public static final String UNTREATED_STR = "未处理";

        /**
         * 已处理
         */
        public static final Integer PROCESSED = 1;

        public static final String PROCESSED_STR = "已处理";

    }

}
