package com.tydic.bcm.personal.dao;

import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 上架申请明细;(bcm_apply_commodity_order_item)表数据库访问层
 *
 * @author : civism
 * @date : 2023-7-28
 */
@Mapper
public interface BcmApplyCommodityOrderItemMapper {
    /**
     * 通过ID查询单条数据
     *
     * @param orderItemId 主键 上架申请单明细
     * @return 实例对象
     */
    BcmApplyCommodityOrderItemPO queryByOrderItemId(Long orderItemId);

    /**
     * 通过ID查询单条数据
     *
     * @param applyOrderId 上架申请单号
     * @return 实例对象
     */
    BcmApplyCommodityOrderItemPO queryByApplyOrderId(Long applyOrderId);

    /**
     * 分页查询指定行数据
     *
     * @param bcmApplyCommodityOrderItem 查询条件
     * @param pageable 分页对象
     * @return 对象列表
     */
    /**
     * 统计总行数
     *
     * @param bcmApplyCommodityOrderItem 查询条件
     * @return 总行数
     */
    long count(BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem);

    /**
     * 新增数据
     *
     * @param bcmApplyCommodityOrderItem 实例对象
     * @return 影响行数
     */
    int insert(BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem);

    /**
     * 批量新增数据
     *
     * @param entities List<BcmApplyCommodityOrderItem> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<BcmApplyCommodityOrderItemPO> entities);

    /**
     * 批量新增或按主键更新数据
     *
     * @param entities List<BcmApplyCommodityOrderItem> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<BcmApplyCommodityOrderItemPO> entities);

    /**
     * 更新数据
     *
     * @param bcmApplyCommodityOrderItem 实例对象
     * @return 影响行数
     */
    int updateByOrderItemId(BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);
}