package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 上架申请单;(bcm_apply_commodity_order)表数据库访问层
 *
 * @author : civism
 * @date : 2023-7-28
 */
@Mapper
public interface BcmApplyCommodityOrderMapper {
    /**
     * 通过orderId查询单条数据
     *
     * @param orderId 主键
     * @return 实例对象
     */
    BcmApplyCommodityOrderPO queryByOrderId(Long orderId);

    /**
     * 统计总行数
     *
     * @param bcmApplyCommodityOrder 查询条件
     * @return 总行数
     */
    long count(BcmApplyCommodityOrderPO bcmApplyCommodityOrder);

    /**
     * 新增数据
     *
     * @param bcmApplyCommodityOrder 实例对象
     * @return 影响行数
     */
    int insert(BcmApplyCommodityOrderPO bcmApplyCommodityOrder);

    /**
     * 批量新增数据
     *
     * @param entities List<BcmApplyCommodityOrder> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<BcmApplyCommodityOrderPO> entities);

    /**
     * 批量新增或按主键更新数据
     *
     * @param entities List<BcmApplyCommodityOrder> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<BcmApplyCommodityOrderPO> entities);

    /**
     * 更新数据
     *
     * @param bcmApplyCommodityOrder 实例对象
     * @return 影响行数
     */
    int update(BcmApplyCommodityOrderPO bcmApplyCommodityOrder);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

    /**
     * 根据条件关联查询待审批分页查询列表数据
     * @param po 参数对象
     * @param page 分页参数
     * @return List<BcmApplyCommodityOrderPO> 结果对象
     */
    List<BcmApplyCommodityOrderPO> queryPendingAuditApplyCommodityOrderPageList(BcmApplyCommodityOrderPO po, Page<BcmApplyCommodityOrderPO> page);
}