package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmBudgetModeConfigPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 类名： BcmBudgetModeConfigMapper
 * 说明：预算模式设置Mapper
 *
 * @author： lishiqing
 * 时间： 2023/7/24 9:57
 */
@Mapper
@Repository
public interface BcmBudgetModeConfigMapper {
    /**
     * 根据条件分页查询列表数据
     * @param budgetModeConfigPO 参数对象
     * @param page  分页参数
     * @return List<BcmPurchasePurposeConfigPO> 结果对象
     */
    List<BcmBudgetModeConfigPO> getPageList(BcmBudgetModeConfigPO budgetModeConfigPO, Page<BcmBudgetModeConfigPO> page);

    /**
     * 根据主键更新数据
     * @param bcmBudgetModeConfigPO 参数对象
     * @return int 影响数量
     */
    int updateById(BcmBudgetModeConfigPO bcmBudgetModeConfigPO);

    /**
     * 根据条件查询列表数据
     *
     * @param budgetModeConfigPO 参数对象
     * @return List<BcmBudgetModeConfigPO> 结果对象
     */
    List<BcmBudgetModeConfigPO> getList(BcmBudgetModeConfigPO budgetModeConfigPO);

    /**
     * 批量插入数据
     * @param list 参数列表
     * @return int 影响数量
     */
    int insertBatch(List<BcmBudgetModeConfigPO> list);
}
