package com.tydic.bcm.personal.dao;

import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 流程实例表;(bcm_flow_instance)表数据库访问层
 *
 * @author : civism
 * @date : 2023-7-28
 */
@Mapper
public interface BcmFlowInstanceMapper {
    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BcmFlowInstancePO queryById(Long id);

    /**
     * 统计总行数
     *
     * @param bcmFlowInstance 查询条件
     * @return 总行数
     */
    long count(BcmFlowInstancePO bcmFlowInstance);

    /**
     * 新增数据
     *
     * @param bcmFlowInstance 实例对象
     * @return 影响行数
     */
    int insert(BcmFlowInstancePO bcmFlowInstance);

    /**
     * 批量新增数据
     *
     * @param entities List<BcmFlowInstance> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<BcmFlowInstancePO> entities);

    /**
     * 批量新增或按主键更新数据
     *
     * @param entities List<BcmFlowInstance> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<BcmFlowInstancePO> entities);

    /**
     * 更新数据
     *
     * @param bcmFlowInstance 实例对象
     * @return 影响行数
     */
    int update(BcmFlowInstancePO bcmFlowInstance);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);
}